/*
 * Decompiled with CFR 0.152.
 */
package net.sf.filePiper.processors;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Arrays;
import net.sf.filePiper.gui.SizeAndUnitEditor;
import net.sf.filePiper.model.FileProcessorEnvironment;
import net.sf.filePiper.model.OneToOneByteFileProcessor;
import net.sf.filePiper.processors.SizeAndUnit;
import net.sf.sfac.gui.editor.ObjectEditor;

public class TailProcessor
extends OneToOneByteFileProcessor
implements SizeAndUnit {
    private static final String TAIL_SIZE = "tail.size";
    private static final String TAIL_UNITS = "tail.units";

    public String getProcessorName() {
        return "Tail";
    }

    public int getSize() {
        return this.getSettings().getIntProperty(TAIL_SIZE, 100);
    }

    public void setSize(int newSize) {
        this.getSettings().setIntProperty(TAIL_SIZE, newSize);
    }

    public int getUnits() {
        return this.getSettings().getIntProperty(TAIL_UNITS, 1);
    }

    public void setUnits(int newUnits) {
        this.getSettings().setIntProperty(TAIL_UNITS, newUnits);
    }

    public String getProposedNameSuffix() {
        return "tail";
    }

    public void process(InputStream is, OutputStream os, FileProcessorEnvironment env) throws IOException {
        if (this.getUnits() == 0) {
            this.processBytes(is, os, env);
        } else {
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(os));
            this.processLines(br, bw, env);
            bw.close();
        }
    }

    public void processBytes(InputStream is, OutputStream os, FileProcessorEnvironment env) throws IOException {
        int j;
        int readByte;
        int size = this.getSize();
        int[] bytes = new int[size];
        Arrays.fill(bytes, -1);
        int i = 0;
        while ((readByte = is.read()) >= 0 && env.shouldContinue()) {
            bytes[i] = readByte;
            this.bytesProcessed(1);
            if (++i < size) continue;
            i = 0;
        }
        for (j = i; j < size && env.shouldContinue(); ++j) {
            if (bytes[j] < 0) continue;
            os.write(bytes[j]);
        }
        for (j = 0; j < i && env.shouldContinue(); ++j) {
            if (bytes[j] < 0) continue;
            os.write(bytes[j]);
        }
    }

    public void processLines(BufferedReader in, BufferedWriter out, FileProcessorEnvironment env) throws IOException {
        int j;
        String line;
        int size = this.getSize();
        String[] lines = new String[size];
        int i = 0;
        while ((line = in.readLine()) != null && env.shouldContinue()) {
            lines[i] = line;
            this.linesProcessed(1);
            if (++i < size) continue;
            i = 0;
        }
        for (j = i; j < size && env.shouldContinue(); ++j) {
            if (lines[j] == null) continue;
            out.write(lines[j]);
            out.newLine();
        }
        for (j = 0; j < i && env.shouldContinue(); ++j) {
            if (lines[j] == null) continue;
            out.write(lines[j]);
            out.newLine();
        }
    }

    public ObjectEditor getEditor() {
        return new SizeAndUnitEditor("Output the X last lines/bytes of the input file", "Tail size");
    }
}

