/*
 * Decompiled with CFR 0.152.
 */
package net.sf.filePiper.processors;

import com.lowagie.text.pdf.PRStream;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.sf.filePiper.model.ExecutionPhase;
import net.sf.filePiper.model.FileProcessor;
import net.sf.filePiper.model.FileProcessorEnvironment;
import net.sf.filePiper.model.InputFileInfo;
import net.sf.filePiper.model.StatusHolder;
import net.sf.sfac.file.FilePathUtils;
import net.sf.sfac.gui.editor.ObjectEditor;
import net.sf.sfac.gui.editor.cmp.ReadOnlyObjectEditor;
import net.sf.sfac.setting.Settings;
import org.apache.log4j.Logger;

public class Pdf2JpegProcessor
implements FileProcessor {
    Logger log = Logger.getLogger(Pdf2JpegProcessor.class);
    private StatusHolder holder = new StatusHolder(){

        protected String getRunningMessage() {
            StringBuilder sb = new StringBuilder();
            sb.append("Extracting ");
            this.appendCount(this.getOutputFileCount(), "Jpeg", sb);
            sb.append(" from ");
            this.appendCount(this.getInputFileCount(), "Pdf", sb);
            sb.append(" (");
            this.appendCount(this.getByteCount(), "byte", sb);
            sb.append(")...");
            return sb.toString();
        }

        protected String getDoneMessage() {
            StringBuilder sb = new StringBuilder();
            this.appendCount(this.getInputFileCount(), "Jpeg", sb);
            sb.append(" extracted from ");
            this.appendCount(this.getOutputFileCount(), "Pdf", sb);
            sb.append(" (");
            this.appendCount(this.getByteCount(), "byte", sb);
            sb.append(").");
            return sb.toString();
        }
    };

    public String getProcessorName() {
        return "Pdf to Jpg";
    }

    public void init(Settings sett) {
    }

    public int getOutputCardinality(int inputCardinality) {
        return 2;
    }

    public void process(InputStream is, InputFileInfo info, FileProcessorEnvironment env) throws IOException {
        String pdfPath = info.getInput().getAbsolutePath();
        String pdfDirectory = FilePathUtils.getDirectoryPath((String)pdfPath);
        String pdfName = info.getProposedName();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Processing PDF: " + pdfPath));
        }
        this.holder.inputFileStarted();
        PdfReader reader = new PdfReader(is);
        int xrefSize = reader.getXrefSize();
        int count = 0;
        for (int i = 0; i < xrefSize && env.shouldContinue(); ++i) {
            PdfObject pdfobj = reader.getPdfObject(i);
            if (pdfobj == null || !pdfobj.isStream()) continue;
            PdfStream stream = (PdfStream)pdfobj;
            PdfObject pdfsubtype = stream.get(PdfName.SUBTYPE);
            PdfObject filter = stream.get(PdfName.FILTER);
            if (!PdfName.IMAGE.equals((Object)pdfsubtype) || !PdfName.DCTDECODE.equals((Object)filter)) continue;
            byte[] image = PdfReader.getStreamBytesRaw((PRStream)((PRStream)stream));
            String imageName = "img" + this.intToString(++count);
            info.setInput(new File(pdfPath + "#" + imageName + ".jpg"));
            info.setProposedPath(FilePathUtils.concatPaths((String)pdfDirectory, (String)pdfName));
            info.setProposedName(imageName);
            info.setProposedExtension("jpg");
            BufferedOutputStream fos = new BufferedOutputStream(env.getOutputStream(info));
            this.holder.outputFileStarted();
            ((OutputStream)fos).write(image);
            this.holder.bytesProcessed(image.length);
            ((OutputStream)fos).close();
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Extracted " + count + " pages  from PDF."));
        }
    }

    private String intToString(int i) {
        StringBuilder sb = new StringBuilder();
        if (i < 100) {
            sb.append('0');
        }
        if (i < 10) {
            sb.append('0');
        }
        sb.append(i);
        return sb.toString();
    }

    public ObjectEditor getEditor() {
        return new ReadOnlyObjectEditor("Extract Jpeg images from Pdf files");
    }

    public void startBatch(FileProcessorEnvironment env) {
        this.holder.reset(ExecutionPhase.STARTING);
    }

    public void endBatch(FileProcessorEnvironment env) {
        this.holder.setCurrentPhase(env.getCurrentPhase());
    }

    public String getStatusMessage() {
        return this.holder.getStatusMessage();
    }
}

