/*
 * Decompiled with CFR 0.152.
 */
package net.sf.filePiper.processors;

import java.io.IOException;
import java.io.InputStream;
import net.sf.filePiper.model.ExecutionPhase;
import net.sf.filePiper.model.FileProcessor;
import net.sf.filePiper.model.FileProcessorEnvironment;
import net.sf.filePiper.model.InputFileInfo;
import net.sf.filePiper.model.StatusHolder;
import net.sf.sfac.gui.editor.ObjectEditor;
import net.sf.sfac.gui.editor.cmp.ReadOnlyObjectEditor;
import net.sf.sfac.setting.Settings;
import org.apache.log4j.Logger;

public class NoOutputProcessor
implements FileProcessor {
    Logger log = Logger.getLogger(NoOutputProcessor.class);
    private StatusHolder holder = new StatusHolder(){

        protected String getRunningMessage() {
            StringBuilder sb = new StringBuilder();
            sb.append("Recieving ");
            this.appendCount(this.getInputFileCount(), "file", sb);
            sb.append("...");
            return sb.toString();
        }

        protected String getDoneMessage() {
            StringBuilder sb = new StringBuilder();
            this.appendCount(this.getInputFileCount(), "file", sb);
            sb.append(" recieved.");
            return sb.toString();
        }
    };

    public String getProcessorName() {
        return "No Output";
    }

    public void init(Settings sett) {
    }

    public int getInputCardinality() {
        return 1;
    }

    public int getOutputCardinality(int inputCardinality) {
        return 0;
    }

    public void process(InputStream is, InputFileInfo line, FileProcessorEnvironment env) throws IOException {
        this.holder.inputFileStarted();
    }

    public void startBatch(FileProcessorEnvironment env) {
        this.holder.reset(ExecutionPhase.STARTING);
    }

    public void endBatch(FileProcessorEnvironment env) {
        this.holder.setCurrentPhase(env.getCurrentPhase());
    }

    public String getStatusMessage() {
        return this.holder.getStatusMessage();
    }

    public ObjectEditor getEditor() {
        return new ReadOnlyObjectEditor("Nothing is forwarded to output");
    }
}

