/*
 * Decompiled with CFR 0.152.
 */
package net.sf.filePiper.processors;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import net.sf.filePiper.model.FileProcessorEnvironment;
import net.sf.filePiper.model.OneToOneTextFileProcessor;
import net.sf.sfac.editor.EditorConfig;
import net.sf.sfac.setting.Settings;
import net.sf.sfac.utils.Comparison;

public class BreakLinesProcessor
extends OneToOneTextFileProcessor {
    private static final String BREAK_PATTERN = "break.pattern";
    private static final String KEEP_BREAK_PATTERN = "break.keep.pattern";
    private Settings sett;

    public String getProcessorName() {
        return "Break lines";
    }

    public String getProcessorDescription() {
        return "Break lines when encountering a defined pattern.";
    }

    @EditorConfig(label="Break at", index=0)
    public String getBreakString() {
        return this.sett.getStringProperty(BREAK_PATTERN, "");
    }

    public void setBreakString(String searchString) {
        this.sett.setStringProperty(BREAK_PATTERN, searchString);
    }

    @EditorConfig(label="Keep break string", index=1)
    public boolean getKeepBreakString() {
        return this.sett.getBooleanProperty(KEEP_BREAK_PATTERN, true);
    }

    public void setKeepBreakString(boolean newKeepBreakString) {
        this.sett.setBooleanProperty(KEEP_BREAK_PATTERN, newKeepBreakString);
    }

    public void init(Settings settgns) {
        this.sett = settgns;
    }

    public void process(BufferedReader in, BufferedWriter out, FileProcessorEnvironment env) throws Exception {
        int ch;
        StringBuilder sb = new StringBuilder();
        String breakString = this.getBreakString();
        boolean keep = this.getKeepBreakString();
        if (Comparison.isEmpty((String)breakString)) {
            throw new IllegalStateException("You must define a break string");
        }
        while ((ch = in.read()) >= 0) {
            sb.append((char)ch);
            if (!this.endsWidth(sb, breakString)) continue;
            int len = sb.length();
            if (!keep) {
                sb.setLength(len - breakString.length());
            }
            out.write(sb.toString());
            out.newLine();
            sb.setLength(0);
        }
    }

    private boolean endsWidth(StringBuilder sb, String str) {
        int strLen = str.length();
        int bufferOffset = sb.length() - strLen;
        if (bufferOffset < 0) {
            return false;
        }
        for (int i = 0; i < strLen; ++i) {
            char ch = str.charAt(i);
            if (ch == sb.charAt(bufferOffset + i)) continue;
            return false;
        }
        return true;
    }

    public String getProposedNameSuffix() {
        return "break";
    }
}

