/*
 * Decompiled with CFR 0.152.
 */
package net.sf.filePiper.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sf.filePiper.model.FileProcessor;
import net.sf.filePiper.model.Pipeline;
import net.sf.sfac.setting.Settings;
import net.sf.sfac.setting.SubSettingsProxy;
import org.apache.log4j.Logger;
import sun.misc.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToolModel {
    private static Logger log = Logger.getLogger(ToolModel.class);
    private Settings sett;
    private SubSettingsProxy pipelineSettings;
    private Pipeline pipeline;
    private List<FileProcessor> availableProcessors;
    private List<ChangeListener> listeners;

    public ToolModel(Settings setts) {
        this.sett = setts;
        this.pipelineSettings = new SubSettingsProxy(this.sett, "currentPipeline");
        log.info((Object)"Initialize pipeline from settings");
        this.pipeline = new Pipeline((Settings)this.pipelineSettings);
    }

    public Settings getSettings() {
        return this.sett;
    }

    public Settings getPipelineSettings() {
        return this.pipelineSettings;
    }

    public void updatePipelineSettings(Settings profile) {
        this.pipelineSettings.clear();
        this.pipelineSettings.copyValues(profile);
        log.info((Object)("Copy pipeline settings from profile: " + profile.getStringProperty("subSettingName", "???")));
        this.pipeline.reset();
        this.fireDataChanged();
    }

    public Pipeline getPipeline() {
        return this.pipeline;
    }

    public List<FileProcessor> getAvailableProcessors() {
        if (this.availableProcessors == null) {
            this.availableProcessors = new ArrayList<FileProcessor>();
            log.info((Object)"SPI retrieving of all FileProcessor");
            Iterator plugInDefs = Service.providers(FileProcessor.class, (ClassLoader)this.getClass().getClassLoader());
            while (plugInDefs.hasNext()) {
                FileProcessor processor = (FileProcessor)plugInDefs.next();
                log.info((Object)("  * FileProcessor = " + processor.getClass()));
                this.availableProcessors.add(processor);
            }
            Collections.sort(this.availableProcessors, new Comparator<FileProcessor>(){

                @Override
                public int compare(FileProcessor fp1, FileProcessor fp2) {
                    return fp1.getProcessorName().compareTo(fp2.getProcessorName());
                }
            });
        }
        return this.availableProcessors;
    }

    public FileProcessor getPrototype(FileProcessor fp) {
        FileProcessor proto = null;
        for (FileProcessor processor : this.getAvailableProcessors()) {
            if (processor.getClass() != fp.getClass()) continue;
            proto = processor;
            break;
        }
        return proto;
    }

    public void addChangeListener(ChangeListener l) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<ChangeListener>();
        }
        this.listeners.add(l);
    }

    public void removeChangeListener(ChangeListener l) {
        if (this.listeners != null) {
            this.listeners.remove(l);
        }
    }

    public void fireDataChanged() {
        if (this.listeners != null) {
            ChangeEvent ev = new ChangeEvent(this);
            for (ChangeListener l : this.listeners) {
                l.stateChanged(ev);
            }
        }
    }
}

