/*
 * Decompiled with CFR 0.152.
 */
package net.sf.filePiper.model;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import net.sf.filePiper.model.FileMatcher;
import net.sf.filePiper.model.InputFileInfo;
import net.sf.filePiper.model.PipeComponent;
import net.sf.filePiper.model.Pipeline;
import net.sf.filePiper.model.PipelineEnvironment;
import org.apache.log4j.Logger;

public class PipelineStart {
    private static Logger log = Logger.getLogger(PipelineStart.class);
    private Pipeline pipeline;

    public PipelineStart(Pipeline thePipeline) {
        this.pipeline = thePipeline;
    }

    public void processInputFiles(PipeComponent firstProcessor, PipelineEnvironment reporter) throws IOException {
        File source = this.pipeline.getSource();
        if (this.pipeline.isSourceMultiFile()) {
            if (source == null) {
                throw new IllegalArgumentException("You must define a source directory");
            }
            if (!source.exists()) {
                throw new IOException("The source directory '" + source.getAbsolutePath() + "' does not exist!");
            }
            FileMatcher matcher = new FileMatcher(source, this.pipeline.getIncludesPattern(), this.pipeline.getExcludesPattern());
            this.processInputFiles(source, matcher, firstProcessor, reporter);
        } else {
            if (source == null) {
                throw new IllegalArgumentException("You must define a source file");
            }
            if (!source.exists()) {
                throw new IOException("The source file '" + source.getAbsolutePath() + "' does not exist!");
            }
            if (!source.isFile()) {
                throw new IOException("The source '" + source.getAbsolutePath() + "' must be a file!");
            }
            this.processFile(source, firstProcessor, reporter);
        }
    }

    private void processInputFiles(File dir, FileMatcher matcher, PipeComponent firstProcessor, PipelineEnvironment reporter) throws IOException {
        if (!reporter.shouldContinue()) {
            return;
        }
        if (!dir.exists()) {
            throw new IOException("Base directory '" + dir.getAbsolutePath() + "' must exist");
        }
        if (!dir.isDirectory()) {
            throw new IOException("Base directory '" + dir.getAbsolutePath() + "' must be a directory");
        }
        reporter.scanningDirectory(dir);
        if (matcher.matchDirectoryTree(dir)) {
            File[] subs;
            for (File fil : subs = dir.listFiles()) {
                if (!reporter.shouldContinue()) {
                    return;
                }
                if (fil.isDirectory()) {
                    this.processInputFiles(fil, matcher, firstProcessor, reporter);
                    continue;
                }
                if (!fil.isFile() || fil.length() <= 0L || !matcher.matchFile(fil)) continue;
                this.processFile(fil, firstProcessor, reporter);
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("Skip directory tree: " + dir));
        }
    }

    private void processFile(File fil, PipeComponent firstProcessor, PipelineEnvironment reporter) throws IOException {
        if (fil.length() == 0L) {
            return;
        }
        reporter.processInputFile(fil);
        File source = this.pipeline.getSource();
        InputFileInfo info = new InputFileInfo(this.pipeline.isSourceMultiFile() ? source : null, fil);
        if (log.isDebugEnabled()) {
            log.debug((Object)("----------- Open file line = " + info));
        }
        FileInputStream is = new FileInputStream(fil);
        firstProcessor.processInputStream(is, info);
    }
}

