/*
 * Decompiled with CFR 0.152.
 */
package net.sf.filePiper.model;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.sf.filePiper.model.InputFileInfo;
import net.sf.filePiper.model.PipeComponent;
import net.sf.filePiper.model.Pipeline;
import net.sf.filePiper.model.PipelineEnvironment;
import net.sf.sfac.file.FilePathUtils;
import net.sf.sfac.file.FileUtils;
import org.apache.log4j.Logger;

public class PipelineEnd
implements PipeComponent {
    private static Logger log = Logger.getLogger(PipelineEnd.class);
    private Pipeline pipeline;
    private FilePathUtils toBaseDir;
    private PipelineEnvironment mainReporting;
    private File tempFile;
    private File output;

    public PipelineEnd(Pipeline thePipeline, FilePathUtils toDir, PipelineEnvironment reporting) {
        this.pipeline = thePipeline;
        this.toBaseDir = toDir;
        this.mainReporting = reporting;
    }

    private void copyTempFile() throws IOException {
        if (this.tempFile != null) {
            try {
                this.copyFile(this.tempFile, this.output);
                boolean success = this.tempFile.delete();
                if (!success) {
                    throw new IllegalStateException("Unable to delete temporary file: " + this.tempFile);
                }
            }
            catch (Exception e) {
                IOException ioe = new IOException("Unable to rename '" + this.tempFile + "' to '" + this.output + "'");
                ioe.initCause(e);
                throw ioe;
            }
        }
        this.tempFile = null;
        this.output = null;
    }

    private void copyFile(File from, File to) throws IOException {
        int read;
        FileUtils.ensureParentDirectoryExists((File)to);
        byte[] buffer = new byte[1024];
        FileInputStream is = new FileInputStream(from);
        FileOutputStream os = new FileOutputStream(to);
        while ((read = is.read(buffer)) > 0) {
            os.write(buffer, 0, read);
        }
        is.close();
        os.close();
    }

    public File getOutputFile(File input, InputFileInfo info) throws IOException {
        if (this.pipeline.getOutputCardinality() == 2) {
            switch (this.pipeline.getOutputNameChoice()) {
                case 0: {
                    String sourceRel = info.getInputRelativePath();
                    String dest = this.toBaseDir.getAbsoluteFilePath(sourceRel);
                    return new File(dest);
                }
                case 1: {
                    String proposedRelativePath = info.getProposedRelativePath();
                    String destPath = this.toBaseDir.getAbsoluteFilePath(proposedRelativePath);
                    return new File(destPath);
                }
                case 2: {
                    throw new IOException("Cannot specify new name for multiple files");
                }
            }
            throw new InternalError("Unknown outputNameChoice value = " + this.pipeline.getOutputNameChoice());
        }
        switch (this.pipeline.getOutputNameChoice()) {
            case 0: {
                return input;
            }
            case 1: {
                return new File(info.getProposedFullPath());
            }
            case 2: {
                if (this.pipeline.getOutputFile() == null) {
                    throw new IllegalArgumentException("You must define a destination file");
                }
                return this.pipeline.getOutputFile();
            }
        }
        throw new InternalError("Unknown outputNameChoice value = " + this.pipeline.getOutputNameChoice());
    }

    public void processInputStream(InputStream input, InputFileInfo info) {
        throw new UnsupportedOperationException("Last node cannot handle input stream");
    }

    public OutputStream createOutputStream(InputFileInfo info) throws IOException {
        this.copyTempFile();
        if (this.pipeline.getOutputDestination() == 11) {
            boolean overwrite;
            File input = info.getInput();
            this.output = this.getOutputFile(input, info);
            File out = this.output;
            if (out.exists() && !(overwrite = this.mainReporting.canOverwriteFile(out))) {
                this.mainReporting.fileSkipped(out);
                return new Sink();
            }
            if (this.output.equals(input)) {
                out = this.tempFile = File.createTempFile("PiperTmp", "tmp");
            }
            FileUtils.ensureParentDirectoryExists((File)this.output);
            if (log.isDebugEnabled()) {
                log.debug((Object)("   === " + this + " Create output for input: " + info));
            }
            this.mainReporting.outputtingToFile(out);
            return new FileOutputStream(out);
        }
        OutputStream out = this.mainReporting.getConsoleStream();
        this.mainReporting.outputtingToFile(null);
        out.write("\n".getBytes());
        out.write(info.getProposedFullPath().getBytes());
        out.write("\n".getBytes());
        out.write("---------------------------------------------------------------------------------".getBytes());
        out.write("\n".getBytes());
        return out;
    }

    public void finished() throws IOException {
        this.copyTempFile();
    }

    static class Sink
    extends OutputStream {
        Sink() {
        }

        public void write(int b) {
        }

        public void write(byte[] b, int off, int len) {
        }

        public void write(byte[] b) {
        }
    }
}

