/*
 * Decompiled with CFR 0.152.
 */
package net.sf.filePiper.model;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.sf.filePiper.model.ExecutionPhase;
import net.sf.filePiper.model.FileProcessor;
import net.sf.filePiper.model.FileProcessorEnvironment;
import net.sf.filePiper.model.InputFileInfo;
import net.sf.filePiper.model.StatusHolder;
import net.sf.sfac.editor.EditorConfig;
import net.sf.sfac.gui.editor.EditorFactory;
import net.sf.sfac.gui.editor.ObjectEditor;
import net.sf.sfac.gui.editor.cmp.ReadOnlyObjectEditor;
import net.sf.sfac.setting.Settings;
import org.apache.log4j.Logger;

public abstract class OneToOneByteFileProcessor
implements FileProcessor {
    private Logger log = Logger.getLogger(OneToOneByteFileProcessor.class);
    private Settings setts;
    private InputFileInfo currentInfo;
    private StatusHolder holder = new StatusHolder();

    public void init(Settings sett) {
        this.setts = sett;
    }

    protected Settings getSettings() {
        return this.setts;
    }

    protected InputFileInfo getCurrentInputFileInfo() {
        return this.currentInfo;
    }

    protected void setCurrentInputFileInfo(InputFileInfo info) {
        this.currentInfo = info;
    }

    public void startBatch(FileProcessorEnvironment env) {
        this.holder.reset(ExecutionPhase.STARTING);
    }

    public void endBatch(FileProcessorEnvironment env) {
        this.holder.setCurrentPhase(env.getCurrentPhase());
    }

    public int getOutputCardinality(int inputCardinality) {
        return inputCardinality;
    }

    public void process(InputStream is, InputFileInfo info, FileProcessorEnvironment env) throws IOException {
        try {
            this.inputFileStarted();
            this.setCurrentInputFileInfo(info);
            this.setProposedFilePath(info);
            OutputStream os = env.getOutputStream(info);
            this.process(is, os, env);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Processor " + this + " closes output stream"));
            }
            os.close();
            this.setCurrentInputFileInfo(null);
        }
        catch (Exception e) {
            this.holder.setCurrentPhase(ExecutionPhase.ERRORED);
            IOException ioe = new IOException("Exception while processing input " + info);
            ioe.initCause(e);
            throw ioe;
        }
    }

    protected void setProposedFilePath(InputFileInfo info) {
        info.addProposedNameSuffix(this.getProposedNameSuffix());
        String proposedExtension = this.getProposedExtension(info);
        if (proposedExtension != null) {
            info.setProposedExtension(proposedExtension);
        }
    }

    protected String getProposedExtension(InputFileInfo info) {
        return null;
    }

    public ObjectEditor getEditor() {
        if (EditorFactory.containsEditorAnnotations(this.getClass())) {
            ObjectEditor ed = EditorFactory.getInstance().createEditor(this.getClass());
            if (!this.getClass().isAnnotationPresent(EditorConfig.class)) {
                ed.setProperty("label", null);
                ed.setProperty("description", (Object)this.getProcessorDescription());
            }
            return ed;
        }
        return new ReadOnlyObjectEditor(this.getProcessorDescription());
    }

    public String getProcessorDescription() {
        return this.getProcessorName() + " processor";
    }

    public String getStatusMessage() {
        return this.holder.getStatusMessage();
    }

    public void inputFileStarted() {
        this.holder.inputFileStarted();
    }

    public void linesProcessed(int nbrLineProcessed) {
        this.holder.linesProcessed(nbrLineProcessed);
    }

    public void bytesProcessed(int nbrByteProcessed) {
        this.holder.bytesProcessed(nbrByteProcessed);
    }

    public abstract String getProcessorName();

    public abstract String getProposedNameSuffix();

    public abstract void process(InputStream var1, OutputStream var2, FileProcessorEnvironment var3) throws Exception;
}

