/*
 * Decompiled with CFR 0.152.
 */
package net.sf.filePiper.model;

import java.io.File;
import net.sf.sfac.file.FilePathUtils;
import net.sf.sfac.file.InvalidPathException;

public class InputFileInfo {
    private File basePath;
    private File input;
    private int inputCount;
    private String proposedPath;
    private String proposedName;
    private String proposedExtension;

    public InputFileInfo(File base, File inputFile) {
        File parentFile;
        this.basePath = base;
        this.input = inputFile;
        if (inputFile != null) {
            this.inputCount = 1;
        }
        this.proposedPath = (parentFile = inputFile.getAbsoluteFile().getParentFile()) == null ? null : parentFile.getAbsolutePath();
        String fullName = inputFile.getName();
        int lastDotIndex = fullName.lastIndexOf(46);
        if (lastDotIndex >= 0) {
            this.proposedName = fullName.substring(0, lastDotIndex);
            this.proposedExtension = fullName.substring(lastDotIndex + 1);
        } else {
            this.proposedName = fullName;
            this.proposedExtension = "";
        }
    }

    public void addProposedNameSuffix(String suffix) {
        this.proposedName = this.proposedName + "_" + suffix;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("InputFileInfo@");
        sb.append(System.identityHashCode(this));
        sb.append("[");
        if (this.inputCount == 1) {
            sb.append(this.input.getAbsolutePath());
        } else {
            sb.append(this.inputCount);
            sb.append(" files, current=");
            sb.append(this.input.getAbsolutePath());
        }
        sb.append("]");
        return sb.toString();
    }

    public void mergeInfo(InputFileInfo mergedInfo) {
        this.inputCount += mergedInfo.inputCount;
    }

    public String getProposedFullPath() {
        StringBuffer fullPath = new StringBuffer();
        if (this.proposedPath != null && this.proposedPath.length() > 0) {
            fullPath.append(this.proposedPath);
            fullPath.append(File.separatorChar);
        }
        fullPath.append(this.proposedName);
        if (this.proposedExtension != null && this.proposedExtension.length() > 0) {
            fullPath.append(".");
            fullPath.append(this.proposedExtension);
        }
        return fullPath.toString();
    }

    public String getProposedRelativePath() {
        StringBuffer relativePath = new StringBuffer();
        if (this.proposedPath != null && this.proposedPath.length() > 0 && this.basePath != null) {
            FilePathUtils utils = this.getFilePathUtils();
            try {
                String path = utils.getRelativeFilePath(this.proposedPath);
                if (path != null && path.length() > 0 && !".".equals(path)) {
                    relativePath.append(path);
                    relativePath.append(File.separatorChar);
                }
            }
            catch (InvalidPathException e) {
                throw new IllegalArgumentException("Inavlid path: " + this.input.getAbsolutePath(), e);
            }
        }
        relativePath.append(this.proposedName);
        if (this.proposedExtension != null && this.proposedExtension.length() > 0) {
            relativePath.append(".");
            relativePath.append(this.proposedExtension);
        }
        return relativePath.toString();
    }

    public void setProposedRelativePath(String newProposedRelativePath) {
    }

    private FilePathUtils getFilePathUtils() {
        return new FilePathUtils(this.basePath == null ? this.input.getParentFile() : this.basePath);
    }

    public String getInputRelativePath() {
        try {
            if (this.basePath != null) {
                return this.getFilePathUtils().getRelativeFilePath(this.input.getAbsolutePath());
            }
        }
        catch (InvalidPathException e) {
            throw new IllegalArgumentException("Inavlid path: " + this.input.getAbsolutePath(), e);
        }
        return this.input.getAbsolutePath();
    }

    public File getInput() {
        return this.input;
    }

    public void setInput(File newInput) {
        this.input = newInput;
    }

    public File getBasePath() {
        return this.basePath;
    }

    public void setBasePath(File newBasePath) {
        this.basePath = newBasePath;
    }

    public String getProposedExtension() {
        return this.proposedExtension;
    }

    public void setProposedExtension(String newProposedExtension) {
        this.proposedExtension = newProposedExtension;
    }

    public String getProposedName() {
        return this.proposedName;
    }

    public void setProposedName(String newProposedName) {
        this.proposedName = newProposedName;
    }

    public String getProposedPath() {
        return this.proposedPath;
    }

    public void setProposedPath(String newProposedPath) {
        this.proposedPath = newProposedPath;
    }

    public int getInputCount() {
        return this.inputCount;
    }
}

