/*
 * Decompiled with CFR 0.152.
 */
package net.sf.filePiper.model;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import net.sf.sfac.file.FilePathUtils;
import net.sf.sfac.file.InvalidPathException;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileMatcher {
    static Logger log = Logger.getLogger(FileMatcher.class);
    private FilePathUtils baseDir;
    private List<Pattern> includes;
    private List<Pattern> excludes;
    private List<Pattern> directoryIncludes;
    private List<Pattern> directoryExcludes;

    public FileMatcher(File sourceBaseDir, String includesPattern, String excludesPattern) {
        this.baseDir = new FilePathUtils(sourceBaseDir);
        includesPattern = includesPattern == null ? null : includesPattern.replace('\\', '/');
        excludesPattern = excludesPattern == null ? null : excludesPattern.replace('\\', '/');
        this.includes = this.getProcessedPatterns(includesPattern, true);
        this.excludes = this.getProcessedPatterns(excludesPattern, false);
        this.directoryIncludes = this.getDirectoryIncludes(includesPattern);
        this.directoryExcludes = this.getDirectoryExcludes(excludesPattern);
    }

    public boolean matchFile(File fil) {
        return this.matches(fil, this.includes, this.excludes);
    }

    public boolean matchDirectoryTree(File fil) {
        return this.matches(fil, this.directoryIncludes, this.directoryExcludes);
    }

    private boolean matches(File fil, List<Pattern> incl, List<Pattern> excl) {
        String filePath;
        if (incl == null && excl == null) {
            return true;
        }
        try {
            filePath = this.baseDir.getRelativeFilePath(fil.getAbsolutePath());
        }
        catch (InvalidPathException e) {
            throw new IllegalArgumentException("Inavlid path: " + fil.getAbsolutePath(), e);
        }
        if (filePath.equals(".")) {
            return true;
        }
        boolean included = this.patternMatches(filePath, incl, true);
        if (included) {
            return !this.patternMatches(filePath, excl, false);
        }
        return false;
    }

    private List<Pattern> getDirectoryIncludes(String includesAntPattern) {
        ArrayList<Pattern> result = null;
        for (String antPattern : this.tokenizePattern(includesAntPattern)) {
            String path;
            Pattern pat;
            if ((antPattern = this.normalize(antPattern)).startsWith("**")) {
                result = null;
                break;
            }
            int includeEnd = -1;
            int doubleStarIndex = antPattern.indexOf("**");
            boolean expand = false;
            if (doubleStarIndex > 0) {
                includeEnd = doubleStarIndex - 1;
                expand = true;
            } else {
                int lastSlashIndex = antPattern.lastIndexOf("/");
                if (lastSlashIndex > 0) {
                    includeEnd = lastSlashIndex;
                }
            }
            if (includeEnd <= 0) continue;
            String[] pathElements = antPattern.substring(0, includeEnd).split("/");
            StringBuffer pathBuffer = new StringBuffer();
            for (String el : pathElements) {
                if (pathBuffer.length() > 0) {
                    pathBuffer.append("/");
                }
                pathBuffer.append(el);
                String path2 = pathBuffer.toString();
                Pattern pat2 = this.getProcessedPattern(path2, false);
                if (pat2 == null) continue;
                log.info((Object)("Directory include pattern = " + path2 + " = " + pat2));
                if (result == null) {
                    result = new ArrayList();
                }
                result.add(pat2);
            }
            if (!expand || (pat = this.getProcessedPattern(path = pathBuffer.toString(), true)) == null) continue;
            log.info((Object)("Directory include pattern = " + path + "/** = " + pat));
            if (result == null) {
                result = new ArrayList<Pattern>();
            }
            result.add(pat);
        }
        return result;
    }

    private List<Pattern> getDirectoryExcludes(String excludesAntPattern) {
        ArrayList<Pattern> result = null;
        for (String antPattern : this.tokenizePattern(excludesAntPattern)) {
            String subPattern;
            Pattern pat;
            if (!(antPattern = this.normalize(antPattern)).endsWith("/**/*") || (pat = this.getProcessedPattern(subPattern = antPattern.substring(0, antPattern.length() - 5), false)) == null) continue;
            log.info((Object)("Directory exclude pattern = " + subPattern + " = " + pat));
            if (result == null) {
                result = new ArrayList<Pattern>();
            }
            result.add(pat);
        }
        return result;
    }

    private String normalize(String antPattern) {
        if (antPattern.endsWith("**")) {
            return antPattern + "/*";
        }
        if (antPattern.endsWith("/")) {
            return antPattern + "**/*";
        }
        return antPattern;
    }

    private List<Pattern> getProcessedPatterns(String antPatternList, boolean include) {
        ArrayList<Pattern> result = null;
        for (String antPattern : this.tokenizePattern(antPatternList)) {
            Pattern pat = this.getProcessedPattern(antPattern = this.normalize(antPattern), false);
            if (pat == null) continue;
            log.info((Object)("File " + (include ? "include" : "exclude") + " pattern = " + antPattern + " = " + pat));
            if (result == null) {
                result = new ArrayList<Pattern>();
            }
            result.add(pat);
        }
        return result;
    }

    private String[] tokenizePattern(String antPattern) {
        String[] tokens = new String[]{};
        if (antPattern != null && !(antPattern = antPattern.trim()).equals("")) {
            tokens = antPattern.split("\\s*,\\s*");
        }
        return tokens;
    }

    private Pattern getProcessedPattern(String antPattern, boolean expanded) {
        if (antPattern == null) {
            return null;
        }
        if ((antPattern = antPattern.trim()).equals("")) {
            return null;
        }
        StringBuffer regExpr = new StringBuffer();
        int len = antPattern.length();
        String separatorPattern = File.separatorChar == '\\' ? "\\\\" : File.separator;
        block6: for (int i = 0; i < len; ++i) {
            char ch = antPattern.charAt(i);
            switch (ch) {
                case '(': 
                case ')': 
                case '.': 
                case '[': 
                case ']': {
                    regExpr.append("\\");
                    regExpr.append(ch);
                    continue block6;
                }
                case '/': {
                    regExpr.append(separatorPattern);
                    continue block6;
                }
                case '?': {
                    regExpr.append("[^");
                    regExpr.append(separatorPattern);
                    regExpr.append("]");
                    continue block6;
                }
                case '*': {
                    if (antPattern.regionMatches(i, "**/", 0, 3)) {
                        regExpr.append("(.*");
                        regExpr.append(separatorPattern);
                        regExpr.append(")*");
                        i += 2;
                        continue block6;
                    }
                    regExpr.append("[^");
                    regExpr.append(separatorPattern);
                    regExpr.append("]*");
                    continue block6;
                }
                default: {
                    regExpr.append(ch);
                }
            }
        }
        if (expanded) {
            regExpr.append(".*");
        }
        return Pattern.compile(regExpr.toString());
    }

    private boolean patternMatches(String filePath, List<Pattern> patterns, boolean defaultMatch) {
        boolean match = defaultMatch;
        if (patterns != null && patterns.size() > 0) {
            match = false;
            for (Pattern includePattern : patterns) {
                if (!includePattern.matcher(filePath).matches()) continue;
                match = true;
                break;
            }
        }
        return match;
    }
}

