/*
 * Decompiled with CFR 0.152.
 */
package net.sf.filePiper.model;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import net.sf.filePiper.model.FileProcessor;
import net.sf.filePiper.model.Pipeline;
import net.sf.filePiper.model.PipelineEnvironment;

public class BasicPipeLineEnvironment
implements PipelineEnvironment {
    private Pipeline pipeline;
    private boolean running;
    private boolean aborted;
    private File scannedDir;
    private File currentSource;
    private File currentDestination;
    private int fileProcessedCount;
    private int outputFileCount;
    private int skippedFileCount;
    private boolean outputToConsole;
    private Exception ex;

    public BasicPipeLineEnvironment(Pipeline processPipeline) {
        this.pipeline = processPipeline;
    }

    public void dumpStatus() {
        System.out.println("" + this.fileProcessedCount + " files processed");
        System.out.println("" + this.outputFileCount + " files written (" + this.skippedFileCount + " skipped)");
        List<FileProcessor> processors = this.pipeline.getProcessors();
        for (FileProcessor processor : processors) {
            System.out.print("  * " + processor + ": " + processor.getStatusMessage());
        }
        if (this.isAborted()) {
            System.out.println(" ------- Aborted by user");
        } else if (this.isErrored()) {
            System.out.println(" ------- Aborted on exception:");
            this.ex.printStackTrace(System.out);
        }
    }

    public void abortProcessing() {
        this.aborted = true;
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean isAborted() {
        return this.aborted;
    }

    public boolean isErrored() {
        return this.ex != null;
    }

    public int getInputFileCount() {
        return this.fileProcessedCount;
    }

    public int getOutputFileCount() {
        return this.outputFileCount;
    }

    public int getSkippedFileCount() {
        return this.skippedFileCount;
    }

    public boolean isOutputToConsole() {
        return this.outputToConsole;
    }

    public Exception getException() {
        return this.ex;
    }

    public void startProcessing() {
        this.running = true;
        this.aborted = false;
        this.fileProcessedCount = 0;
        this.outputFileCount = 0;
        this.skippedFileCount = 0;
        this.currentSource = null;
        this.currentDestination = null;
        this.outputToConsole = false;
    }

    public void scanningDirectory(File dir) {
        this.scannedDir = dir;
    }

    public void processInputFile(File newSrc) {
        ++this.fileProcessedCount;
        this.currentSource = newSrc;
        this.scannedDir = null;
    }

    public void outputtingToFile(File newDest) {
        ++this.outputFileCount;
        this.currentDestination = newDest;
        this.outputToConsole = newDest == null;
    }

    public File getCurrentScannedDirectory() {
        return this.scannedDir;
    }

    public File getCurrentInputFile() {
        return this.currentSource;
    }

    public File getCurrentOutputFile() {
        return this.currentDestination;
    }

    public void finished(Exception e) {
        this.running = false;
        if (e != null && this.ex == null) {
            this.ex = e;
        }
    }

    public boolean shouldContinue() {
        return !this.aborted && this.ex == null;
    }

    public boolean canOverwriteFile(File newFil) {
        return true;
    }

    public void fileSkipped(File dest) {
        ++this.skippedFileCount;
    }

    public OutputStream getConsoleStream() {
        return new ConsoleStream();
    }

    static class ConsoleStream
    extends OutputStream {
        ConsoleStream() {
        }

        public void write(int b) throws IOException {
            System.out.write(b);
        }

        public void write(byte[] b) throws IOException {
            System.out.write(b);
        }

        public void write(byte[] b, int start, int len) throws IOException {
            System.out.write(b, start, len);
        }

        public void close() {
            System.out.flush();
        }
    }
}

