/*
 * Decompiled with CFR 0.152.
 */
package net.sf.filePiper.gui;

import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sf.filePiper.gui.GuiPipelineEnvironment;
import net.sf.filePiper.gui.PipeEndsEditor;
import net.sf.filePiper.gui.StatusBar;
import net.sf.filePiper.gui.borders.FileProcessorBorder;
import net.sf.filePiper.model.FileProcessor;
import net.sf.filePiper.model.Pipeline;
import net.sf.filePiper.model.ToolModel;
import net.sf.sfac.gui.ExceptionDialog;
import net.sf.sfac.gui.cmp.ConsoleDialog;
import net.sf.sfac.gui.editor.ObjectEditor;
import net.sf.sfac.gui.framework.AboutlHelper;
import net.sf.sfac.gui.framework.ActionRepository;
import net.sf.sfac.gui.framework.SharedResources;
import net.sf.sfac.gui.layout.MultiBorder;
import net.sf.sfac.gui.layout.MultiBorderConstraints;
import net.sf.sfac.gui.layout.MultiBorderLayout;
import net.sf.sfac.setting.ProfilesClient;
import net.sf.sfac.setting.Settings;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PiperMainPanel
extends JPanel
implements ProfilesClient {
    private static final String ABOUT_TEXT = "<html><center><h1>The File Piper</h1>version 1.0<br><br>General-purpose file processing tool<br><br><br><br><br><br><br><br>by<br>Olivier Berlanger</center></html>";
    private static final String ABOUT_LICENSE = "<html>This software is distributed with <a href='http://www.apache.org/licenses'>Apache 2 license</a>.<br>&copy; 2010 Olivier Berlanger<br><br><br>It uses following open-source librarires<ul><li>Commons-logging and log4j from<br>the <a href='http://www.apache.org'>Apache Software Foundation</a><li>The <a href='http://sfac.sourceforge.net'>Swing Framework and Components</a><br>(SFaC) project</ul>See the NOTICE.txt file for more info.</html>";
    private static Logger log = Logger.getLogger(PiperMainPanel.class);
    private final FileProcessorBorder.Listener BORDER_LISTENER = new FileProcessorBorder.Listener(){

        public void addActionPerformed(FileProcessorBorder source) {
            PiperMainPanel.this.addProcessorAt(source);
        }

        public void removeActionPerformed(FileProcessorBorder source) {
            PiperMainPanel.this.removeProcessor(source);
        }
    };
    ToolModel model;
    private boolean currentSourceMultiFile;
    private PipeEndsEditor endsEditor;
    private List<ObjectEditor> processorEditors;
    private List<FileProcessorBorder> borders;
    private StatusBar sourceStatus;
    private StatusBar destinationStatus;
    private List<StatusBar> processorStatus;
    private GuiPipelineEnvironment guiEnvironment;
    private Action processAction;
    private Action abortAction;
    private Action showConsoleAction;
    private ConsoleDialog console;

    public PiperMainPanel(ToolModel mainModel, ActionRepository repo) {
        super((LayoutManager)new MultiBorderLayout());
        MultiBorderLayout layout = (MultiBorderLayout)this.getLayout();
        layout.setGlobalInsets(new Insets(8, 15, 8, 15));
        this.model = mainModel;
        this.endsEditor = new PipeEndsEditor(this.model.getSettings(), this);
        this.endsEditor.edit(this.model.getPipeline());
        this.processorEditors = new ArrayList<ObjectEditor>();
        this.borders = new ArrayList<FileProcessorBorder>();
        this.createActions(repo);
        this.buildGui();
        this.model.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                PiperMainPanel.this.rebuildGui();
            }
        });
        this.updateActionState(false);
    }

    public Settings getSettings() {
        return this.model.getSettings();
    }

    StatusBar getSourceStatus() {
        return this.sourceStatus;
    }

    StatusBar getDestinationStatus() {
        return this.destinationStatus;
    }

    List<StatusBar> getProcessorStatus() {
        return this.processorStatus;
    }

    public ConsoleDialog getConsole() {
        if (this.console == null) {
            this.console = new ConsoleDialog(JOptionPane.getFrameForComponent(this), "Console", this.getSettings());
            this.console.setDefaultCloseOperation(0);
            this.console.addWindowListener((WindowListener)new WindowAdapter(){

                public void windowClosing(WindowEvent newE) {
                    PiperMainPanel.this.setConsoleVisible(false);
                }
            });
        }
        return this.console;
    }

    public boolean isConsoleVisible() {
        if (this.console == null) {
            return false;
        }
        return this.getConsole().isVisible();
    }

    public void setConsoleVisible(boolean visible) {
        try {
            if (visible != this.isConsoleVisible()) {
                this.getConsole().setVisible(visible);
                if (visible != ActionRepository.isActionSelected((Action)this.showConsoleAction)) {
                    ActionRepository.setActionSelected((Action)this.showConsoleAction, (boolean)visible);
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Unable to show the console", (Throwable)e);
            ExceptionDialog.showExceptionDialog((Component)this, (String)"Processing error", (String)"Unable to show the console", (Throwable)e);
        }
    }

    public void exit() {
        log.info((Object)"Exit application ...");
        try {
            this.updateModel();
            this.getSettings().save();
        }
        catch (Exception e) {
            log.error((Object)("Cannot save settings in " + this.getSettings().getPropertyFilePath()), (Throwable)e);
            ExceptionDialog.showExceptionDialog((Component)this, (String)"Settings error", (String)("Unable to save settings in file:\n" + this.getSettings().getPropertyFilePath()), (Throwable)e);
        }
        System.exit(0);
    }

    void process() {
        log.info((Object)"Start file processing ...");
        try {
            this.updateModel();
            this.updateActionState(true);
            Pipeline pipeline = this.model.getPipeline();
            this.guiEnvironment = new GuiPipelineEnvironment(pipeline, this);
            this.guiEnvironment.startUpdate();
            pipeline.process(this.guiEnvironment);
        }
        catch (Exception e) {
            log.error((Object)"Cannot process file(s)", (Throwable)e);
            ExceptionDialog.showExceptionDialog((Component)this, (String)"Processing error", (String)"Unable to process file(s)", (Throwable)e);
        }
    }

    void abort() {
        log.info((Object)"Abort current file processing ...");
        try {
            if (this.guiEnvironment != null) {
                this.guiEnvironment.abortProcessing();
            } else {
                log.warn((Object)"The process cannot be aborted because current GUI environment is null");
            }
        }
        catch (Exception e) {
            log.error((Object)"The current file processing cannot be aborted", (Throwable)e);
            ExceptionDialog.showExceptionDialog((Component)this, (String)"Processing error", (String)"Unable to abort", (Throwable)e);
        }
    }

    void addProcessorAt(FileProcessorBorder source) {
        int index = this.borders.indexOf((Object)source);
        log.info((Object)("Add processor at " + index));
        try {
            this.updateModel();
            this.model.getPipeline().duplicateProcessor(index);
            this.rebuildGui();
        }
        catch (Exception e) {
            log.error((Object)("Cannot add processor at index " + index), (Throwable)e);
            ExceptionDialog.showExceptionDialog((Component)this, (String)"Internal error", (String)"Unable to add processor", (Throwable)e);
        }
    }

    void removeProcessor(FileProcessorBorder source) {
        int index = this.borders.indexOf((Object)source);
        log.info((Object)("Remove processor at " + index));
        try {
            this.updateModel();
            this.model.getPipeline().removeProcessor(index);
            this.rebuildGui();
        }
        catch (Exception e) {
            log.error((Object)("Cannot remove processor at index " + index), (Throwable)e);
            ExceptionDialog.showExceptionDialog((Component)this, (String)"Internal error", (String)"Unable to remove processor", (Throwable)e);
        }
    }

    void finished() {
        this.updateActionState(false);
    }

    void rebuildGui() {
        this.currentSourceMultiFile = this.model.getPipeline().isSourceMultiFile();
        this.endsEditor.edit(this.model.getPipeline());
        this.buildGui();
        this.revalidate();
        this.repaint();
    }

    void updateModel() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"------ Update tool model");
        }
        this.endsEditor.updateModel();
        for (ObjectEditor ed : this.processorEditors) {
            ed.updateModel();
        }
    }

    private void updateView() {
        this.endsEditor.updateView();
        for (ObjectEditor ed : this.processorEditors) {
            ed.updateView();
        }
    }

    private void updateActionState(boolean running) {
        this.processAction.setEnabled(!running);
        this.abortAction.setEnabled(running);
        this.endsEditor.setEditable(!running);
        for (ObjectEditor ed : this.processorEditors) {
            ed.setEditable(!running);
        }
    }

    private void buildGui() {
        int fromCardinality;
        this.removeAll();
        MultiBorderConstraints constr = new MultiBorderConstraints();
        Insets defaultInsets = new Insets(10, 0, 0, 0);
        Insets processorInsets = new Insets(10, 10, 0, 10);
        constr.insets = defaultInsets;
        constr.gridx = 1;
        constr.gridy = -1;
        constr.anchor = 10;
        constr.weightx = 0.6;
        constr.fill = 2;
        MultiBorderConstraints statusConstr = new MultiBorderConstraints(constr);
        statusConstr.fill = 2;
        MultiBorderConstraints spaceConstr = new MultiBorderConstraints(constr);
        spaceConstr.weightx = 0.2;
        Pipeline pipeline = this.model.getPipeline();
        this.currentSourceMultiFile = pipeline.isSourceMultiFile();
        this.endsEditor.checkCardinality();
        MultiBorder srcBorder = new MultiBorder("Source");
        constr.addBorder(srcBorder);
        statusConstr.addBorder(srcBorder);
        this.sourceStatus = new StatusBar();
        this.add((Component)this.endsEditor.getSourcePanel(), constr);
        constr.weightx = 0.0;
        this.add((Component)new JLabel(" "), spaceConstr.setConstraints(0, 0));
        this.add((Component)new JLabel(" "), spaceConstr.setConstraints(2, 0));
        this.add((Component)this.sourceStatus, statusConstr);
        constr.removeBorder(srcBorder);
        statusConstr.removeBorder(srcBorder);
        int toCardinality = fromCardinality = this.currentSourceMultiFile ? 2 : 1;
        constr.setConstraints(0, -1, 3, 1);
        statusConstr.setConstraints(0, -1, 3, 1);
        List<FileProcessor> processors = pipeline.getProcessors();
        this.processorStatus = new ArrayList<StatusBar>();
        this.processorEditors.clear();
        this.borders.clear();
        int len = processors.size();
        for (int i = 0; i < len; ++i) {
            constr.insets = null;
            this.add((Component)this.getLabel(fromCardinality, toCardinality), constr);
            constr.insets = processorInsets;
            FileProcessor fp = processors.get(i);
            JComboBox combo = this.createProcessorCombo();
            combo.setSelectedItem(this.model.getPrototype(fp));
            combo.addItemListener(new ComboListener(i));
            FileProcessorBorder procBorder = new FileProcessorBorder(combo);
            this.borders.add(procBorder);
            procBorder.addBorderListsner(this.BORDER_LISTENER);
            constr.addBorder((MultiBorder)procBorder);
            statusConstr.addBorder((MultiBorder)procBorder);
            StatusBar bar = new StatusBar();
            this.processorStatus.add(bar);
            ObjectEditor ed = fp.getEditor();
            ed.edit((Object)fp);
            this.processorEditors.add(ed);
            JComponent cmp = ed.getEditorComponent();
            cmp.setBorder(null);
            this.add((Component)cmp, constr);
            this.add((Component)bar, statusConstr);
            constr.removeBorder((MultiBorder)procBorder);
            statusConstr.removeBorder((MultiBorder)procBorder);
            fromCardinality = toCardinality;
            toCardinality = fp.getOutputCardinality(fromCardinality);
        }
        this.setRemoveProcessButtonEnabled();
        constr.insets = null;
        this.add((Component)this.getLabel(fromCardinality, toCardinality), constr);
        constr.setConstraints(1, -1, 1, 1);
        statusConstr.setConstraints(1, -1, 1, 1);
        constr.insets = defaultInsets;
        MultiBorder destBorder = new MultiBorder("Destination");
        constr.addBorder(destBorder);
        statusConstr.addBorder(destBorder);
        this.destinationStatus = new StatusBar();
        this.add((Component)this.endsEditor.getDestinationPanel(), constr);
        this.add((Component)this.destinationStatus, statusConstr);
        constr.removeBorder(destBorder);
        statusConstr.removeBorder(destBorder);
        this.updateView();
    }

    public void checkCardinality() {
        if (this.currentSourceMultiFile != this.model.getPipeline().isSourceMultiFile()) {
            this.rebuildGui();
        }
    }

    private JLabel getLabel(int fromCardinality, int toCardinality) {
        JLabel label;
        if (fromCardinality == 2) {
            switch (toCardinality) {
                case 0: {
                    label = new JLabel(SharedResources.getIcon((String)"manyToNone.png"));
                    break;
                }
                case 1: {
                    label = new JLabel(SharedResources.getIcon((String)"manyToOne.png"));
                    break;
                }
                default: {
                    label = new JLabel(SharedResources.getIcon((String)"manyToMany.png"));
                    break;
                }
            }
        } else {
            switch (toCardinality) {
                case 0: {
                    label = new JLabel(SharedResources.getIcon((String)"oneToNone.png"));
                    break;
                }
                case 1: {
                    label = new JLabel(SharedResources.getIcon((String)"oneToOne.png"));
                    break;
                }
                default: {
                    label = new JLabel(SharedResources.getIcon((String)"oneToMany.png"));
                }
            }
        }
        label.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        return label;
    }

    private void setRemoveProcessButtonEnabled() {
        boolean enabled = this.borders.size() > 1;
        for (FileProcessorBorder border : this.borders) {
            border.setRemoveButtonEnabled(enabled);
        }
    }

    void comboStateChanged(int processorIndex, FileProcessor proto) {
        this.updateModel();
        Pipeline pipeline = this.model.getPipeline();
        pipeline.changeProcessorAt(processorIndex, proto);
        this.buildGui();
        this.revalidate();
        this.repaint();
    }

    private JComboBox createProcessorCombo() {
        List<FileProcessor> availableProcessors = this.model.getAvailableProcessors();
        DefaultComboBoxModel<Object> comboModel = new DefaultComboBoxModel<Object>(availableProcessors.toArray());
        JComboBox<Object> combo = new JComboBox<Object>(comboModel);
        combo.setRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                String text = value == null ? "" : ((FileProcessor)value).getProcessorName();
                return super.getListCellRendererComponent((JList<?>)list, text, index, isSelected, cellHasFocus);
            }
        });
        return combo;
    }

    private void createActions(ActionRepository repo) {
        repo.addAction("exit", "Exit", "Exit the application", "File", "a/z9", null, null, (Action)new AbstractAction(){

            public void actionPerformed(ActionEvent ae) {
                PiperMainPanel.this.exit();
            }
        });
        this.processAction = repo.addAction("process", "Process", "Process file(s)", "Action", "b/a1", "a1", (Icon)SharedResources.getIcon((String)"process.gif"), (Action)new AbstractAction(){

            public void actionPerformed(ActionEvent ae) {
                PiperMainPanel.this.process();
            }
        });
        this.abortAction = repo.addAction("abort", "Abort", "Abort processing", "Action", "b/a2", "a2", (Icon)SharedResources.getIcon((String)"abort.gif"), (Action)new AbstractAction(){

            public void actionPerformed(ActionEvent ae) {
                PiperMainPanel.this.abort();
            }
        });
        this.showConsoleAction = repo.addAction("showConsole", "Show/Hide Console", "Show/Hide the console", "View", "d/a2", "a3", (Icon)SharedResources.getIcon((String)"viewToolBar.png"), (Action)new AbstractAction(){

            public void actionPerformed(ActionEvent ae) {
                boolean visible = ActionRepository.isActionSelected((Action)this);
                PiperMainPanel.this.setConsoleVisible(visible);
            }
        });
        ActionRepository.setToggleAction((Action)this.showConsoleAction);
        ActionRepository.setActionSelected((Action)this.showConsoleAction, (boolean)this.isConsoleVisible());
        AboutlHelper about = new AboutlHelper((Component)this);
        about.setDirectText("About the File Piper", ABOUT_TEXT, ABOUT_LICENSE);
        about.setAboutIcon((Icon)SharedResources.getIcon((String)"PiperAbout.png"));
        about.createAction(repo);
    }

    public Settings getGlobalSettings() {
        return this.model.getSettings();
    }

    public Settings getCurrentSubSettings() {
        this.updateModel();
        return this.model.getPipelineSettings();
    }

    public void updateCurrentSubSettings(Settings profile) {
        this.model.updatePipelineSettings(profile);
    }

    class ComboListener
    implements ItemListener {
        private int processorIndex;

        ComboListener(int index) {
            this.processorIndex = index;
        }

        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                PiperMainPanel.this.comboStateChanged(this.processorIndex, (FileProcessor)e.getItem());
            }
        }
    }
}

