/*
 * Decompiled with CFR 0.152.
 */
package net.sf.filePiper.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Arrays;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import net.sf.filePiper.gui.PipeEndsDescriptions;
import net.sf.filePiper.gui.PiperMainPanel;
import net.sf.filePiper.model.Pipeline;
import net.sf.sfac.file.FileType;
import net.sf.sfac.gui.editor.cmp.BaseObjectEditor;
import net.sf.sfac.gui.utils.FileDropListener;
import net.sf.sfac.setting.Settings;
import org.apache.log4j.Logger;

public class PipeEndsEditor
extends BaseObjectEditor
implements PipeEndsDescriptions {
    private static final String DEFAULT_CHOOSER_SRC_DIRECTORY = "chooser.default.src.dir";
    private static final String DEFAULT_CHOOSER_DEST_DIRECTORY = "chooser.default.dest.dir";
    private static Logger log = Logger.getLogger(PipeEndsEditor.class);
    private Pipeline pipeline;
    private PiperMainPanel mainPane;
    private boolean sourceMultiFile;
    private int currentOutputCardinality;
    private int outputDestination;
    private int outputNameChoice;
    private Settings setts;
    private JPanel sourcePane;
    private JLabel sourceTypeLabel;
    private JRadioButton sourceSingleChoice;
    private JRadioButton sourceMultiChoice;
    private JLabel sourceBaseLabel;
    private JTextField sourceBase;
    private TextfieldFileDropAdapter sourceBaseDropAdapter;
    private JButton sourceHelper;
    private JLabel includePatternLabel;
    private JTextField includePattern;
    private JLabel excludePatternLabel;
    private JTextField excludePattern;
    private JPanel destinationPane;
    private JLabel outputDestinationLabel;
    private JRadioButton fileDestination;
    private JRadioButton consoleDestination;
    private JLabel outputNameTypeLabel;
    private JRadioButton currentNameChoice;
    private JRadioButton proposedNameChoice;
    private JRadioButton newNameChoice;
    private JLabel destinationBaseLabel;
    private JTextField destinationBase;
    private TextfieldFileDropAdapter destinationBaseDropAdapter;
    private JButton destinationHelper;

    public PipeEndsEditor(Settings settgns, PiperMainPanel mainPanel) {
        this.setts = settgns;
        this.mainPane = mainPanel;
    }

    public JComponent getSourcePanel() {
        this.buildGui();
        return this.sourcePane;
    }

    public JComponent getDestinationPanel() {
        this.buildGui();
        return this.destinationPane;
    }

    private void buildGui() {
        if (this.sourcePane == null) {
            this.createSourcePane();
            this.createDestinationPane();
            this.synchronizeEditableState();
            this.updateGui();
        }
    }

    private void createSourcePane() {
        this.sourcePane = new JPanel(new GridBagLayout());
        this.sourceTypeLabel = new JLabel("Multiplicity");
        this.sourceTypeLabel.setToolTipText("<html>Multiplicity of source<ul><li><b>Single</b>: source is a single file<li><b>Multiple</b>: source is set of files</ul></html>");
        ButtonGroup radios = new ButtonGroup();
        this.sourceSingleChoice = new JRadioButton("Single");
        this.sourceSingleChoice.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent newE) {
                PipeEndsEditor.this.setMultiFile(false);
            }
        });
        radios.add(this.sourceSingleChoice);
        this.sourceMultiChoice = new JRadioButton("Multiple");
        this.sourceMultiChoice.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent newE) {
                PipeEndsEditor.this.setMultiFile(true);
            }
        });
        radios.add(this.sourceMultiChoice);
        this.sourcePane.add((Component)this.sourceTypeLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 10, 0, 4), 0, 0));
        this.sourcePane.add((Component)this.sourceSingleChoice, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 4), 0, 0));
        this.sourcePane.add((Component)this.sourceMultiChoice, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.sourceBaseLabel = new JLabel("Input file");
        this.sourceBaseLabel.setToolTipText("<html>Directory that contains all<br>the files to be processed (possibly in sub-directories)</html>");
        this.sourceBase = new JTextField(20);
        this.sourceBaseDropAdapter = new TextfieldFileDropAdapter(this.sourceBase);
        this.sourceHelper = new JButton("...");
        this.sourceHelper.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                PipeEndsEditor.this.displayHelper(true);
            }
        });
        this.sourcePane.add((Component)this.sourceBaseLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 10, 0, 4), 0, 0));
        this.sourcePane.add((Component)this.sourceBase, new GridBagConstraints(1, 1, 2, 1, 0.0, 0.0, 17, 2, new Insets(2, 0, 0, 4), 0, 0));
        this.sourcePane.add((Component)this.sourceHelper, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 0, 0, 10), 0, 0));
        this.includePatternLabel = new JLabel("Includes");
        this.includePatternLabel.setToolTipText("<html>Ant-like description of the files to includes.<br>Possible wildcards:<ul><li><b>**</b>: all directories or sub-sirectories (including current)<li><b>*</b>: any characters sequence in file or directory name (excluding '/')<li><b>?</b>: any characters in file or directory name (excluding '/')</ul>Tip: Always use forward slashes '/' as path separator in includes and excludes.</html>");
        this.includePattern = new JTextField(20);
        this.sourcePane.add((Component)this.includePatternLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 10, 0, 4), 0, 0));
        this.sourcePane.add((Component)this.includePattern, new GridBagConstraints(1, 2, 3, 1, 0.0, 0.0, 17, 2, new Insets(2, 0, 0, 10), 0, 0));
        this.excludePatternLabel = new JLabel("Excludes");
        this.excludePatternLabel.setToolTipText("<html>Ant-like description of the files to excludes.<br>Possible wildcards:<ul><li><b>**</b>: all directories or sub-sirectories (including current)<li><b>*</b>: any characters sequence in file or directory name (excluding '/')<li><b>?</b>: any characters in file or directory name (excluding '/')</ul>Tip: Always use forward slashes '/' as path separator in includes and excludes.<br>&nbsp;&nbsp;&nbsp;&nbsp; If an excludes ends with /**/* the whole corresponding directory sub-tree can be skipped,<br>&nbsp;&nbsp;&nbsp;&nbsp; it increase directory scanning performance.</html>");
        this.excludePattern = new JTextField(20);
        this.sourcePane.add((Component)this.excludePatternLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 10, 0, 4), 0, 0));
        this.sourcePane.add((Component)this.excludePattern, new GridBagConstraints(1, 3, 3, 1, 0.0, 0.0, 17, 2, new Insets(2, 0, 0, 10), 0, 0));
    }

    private void createDestinationPane() {
        this.destinationPane = new JPanel(new GridBagLayout());
        this.outputDestinationLabel = new JLabel("Output destination");
        this.outputDestinationLabel.setToolTipText("<html>Output destination<ul><li><b>Files</b>: file(s) writtent on disk<li><b>Console</b>: output content displayed on an internal console</ul></html>");
        ButtonGroup destinationRadios = new ButtonGroup();
        this.fileDestination = new JRadioButton("File");
        this.fileDestination.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent newE) {
                PipeEndsEditor.this.setOutputDestination(11);
            }
        });
        destinationRadios.add(this.fileDestination);
        this.consoleDestination = new JRadioButton("Console");
        this.consoleDestination.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent newE) {
                PipeEndsEditor.this.setOutputDestination(10);
            }
        });
        destinationRadios.add(this.consoleDestination);
        this.destinationPane.add((Component)this.outputDestinationLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 10, 0, 4), 0, 0));
        this.destinationPane.add((Component)this.fileDestination, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 4), 0, 0));
        this.destinationPane.add((Component)this.consoleDestination, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.outputNameTypeLabel = new JLabel("Output file name");
        this.outputNameTypeLabel.setToolTipText("<html>What to use as output file name/path<ul><li><b>Current</b>: the same as the input file<li><b>Proposed</b>: a new name proposed by the file processors<li><b>New</b>: specify the new name (only for single file)</ul></html>");
        ButtonGroup radios = new ButtonGroup();
        this.currentNameChoice = new JRadioButton("Current");
        this.currentNameChoice.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent newE) {
                PipeEndsEditor.this.setOutputNameChoice(0);
            }
        });
        radios.add(this.currentNameChoice);
        this.proposedNameChoice = new JRadioButton("Proposed");
        this.proposedNameChoice.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent newE) {
                PipeEndsEditor.this.setOutputNameChoice(1);
            }
        });
        radios.add(this.proposedNameChoice);
        this.newNameChoice = new JRadioButton("New");
        this.newNameChoice.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent newE) {
                PipeEndsEditor.this.setOutputNameChoice(2);
            }
        });
        radios.add(this.newNameChoice);
        this.destinationPane.add((Component)this.outputNameTypeLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 10, 0, 4), 0, 0));
        this.destinationPane.add((Component)this.currentNameChoice, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 4), 0, 0));
        this.destinationPane.add((Component)this.proposedNameChoice, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.destinationPane.add((Component)this.newNameChoice, new GridBagConstraints(3, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.destinationBaseLabel = new JLabel("Output file");
        this.destinationBaseLabel.setToolTipText("<html>The output (single) file</html>");
        this.destinationBase = new JTextField(20);
        this.destinationBaseDropAdapter = new TextfieldFileDropAdapter(this.destinationBase);
        this.destinationBaseDropAdapter.setDirectoryOnly(true);
        this.destinationHelper = new JButton("...");
        this.destinationHelper.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                PipeEndsEditor.this.displayHelper(false);
            }
        });
        this.destinationPane.add((Component)this.destinationBaseLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 10, 0, 4), 0, 0));
        this.destinationPane.add((Component)this.destinationBase, new GridBagConstraints(1, 2, 3, 1, 0.0, 0.0, 17, 2, new Insets(2, 0, 0, 4), 0, 0));
        this.destinationPane.add((Component)this.destinationHelper, new GridBagConstraints(4, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 0, 0, 10), 0, 0));
    }

    void setOutputDestination(int newOutputDestination) {
        if (this.outputDestination != newOutputDestination) {
            this.outputDestination = newOutputDestination;
            this.updateGui();
        }
    }

    void setMultiFile(boolean multi) {
        if (this.sourceMultiFile != multi) {
            this.sourceMultiFile = multi;
            if (this.pipeline != null) {
                this.pipeline.setSourceMultiFile(multi);
            }
            this.mainPane.checkCardinality();
            this.updateGui();
        }
    }

    void setOutputNameChoice(int newOutputNameChoice) {
        if (this.outputNameChoice != newOutputNameChoice) {
            this.outputNameChoice = newOutputNameChoice;
            this.updateGui();
        }
    }

    private void updateGui() {
        if (this.sourcePane != null) {
            boolean destinationMultiple;
            boolean cmpEditable = this.isEditable();
            boolean cmpEnabled = this.isEnabled();
            if (this.sourceMultiFile) {
                this.sourceMultiChoice.setSelected(true);
            } else {
                this.sourceSingleChoice.setSelected(true);
            }
            this.sourceBaseLabel.setText(this.sourceMultiFile ? "Base directory" : "Input file");
            this.sourceBaseLabel.setToolTipText(this.sourceMultiFile ? "<html>Directory that contains all<br>the files to be processed (possibly in sub-directories)</html>" : "<html>File that will be processed by the tool</html>");
            this.sourceBaseDropAdapter.setDirectoryOnly(this.sourceMultiFile);
            this.includePatternLabel.setVisible(this.sourceMultiFile);
            this.excludePatternLabel.setVisible(this.sourceMultiFile);
            this.includePattern.setVisible(this.sourceMultiFile);
            this.excludePattern.setVisible(this.sourceMultiFile);
            this.sourceBase.setEditable(cmpEditable);
            this.includePattern.setEditable(cmpEditable);
            this.excludePattern.setEditable(cmpEditable);
            this.sourceBase.setEnabled(cmpEnabled);
            this.includePattern.setEnabled(cmpEnabled);
            this.excludePattern.setEnabled(cmpEnabled);
            this.sourceSingleChoice.setEnabled(cmpEditable && cmpEnabled);
            this.sourceMultiChoice.setEnabled(cmpEditable && cmpEnabled);
            this.sourceHelper.setEnabled(cmpEditable && cmpEnabled);
            this.currentOutputCardinality = this.pipeline.getOutputCardinality();
            boolean outputToFile = this.outputDestination == 11;
            boolean outputIsUsed = this.currentOutputCardinality > 0;
            boolean bl = destinationMultiple = this.currentOutputCardinality == 2;
            if (outputToFile) {
                this.fileDestination.setSelected(true);
            } else {
                this.consoleDestination.setSelected(true);
            }
            if (this.outputNameChoice == 0) {
                this.currentNameChoice.setSelected(true);
            } else if (this.outputNameChoice == 1) {
                this.proposedNameChoice.setSelected(true);
            } else if (this.outputNameChoice == 2) {
                if (destinationMultiple) {
                    this.outputNameChoice = 1;
                    this.proposedNameChoice.setSelected(true);
                } else {
                    this.newNameChoice.setSelected(true);
                }
            }
            boolean showDestinationField = outputToFile && (destinationMultiple || this.outputNameChoice == 2);
            this.outputNameTypeLabel.setVisible(outputToFile);
            this.currentNameChoice.setVisible(outputToFile);
            this.proposedNameChoice.setVisible(outputToFile);
            this.newNameChoice.setVisible(outputToFile);
            this.destinationBaseLabel.setText(destinationMultiple ? "Target directory" : "Output file");
            this.destinationBaseLabel.setToolTipText(destinationMultiple ? "<html>The target directory to use for output.<br>If different from the source base directory, the sub-directories that were found<br> under this base directory are recreated to write the output files in the same structure.</html>" : "<html>The output (single) file</html>");
            this.destinationBaseLabel.setVisible(showDestinationField);
            this.destinationBase.setVisible(showDestinationField);
            this.destinationHelper.setVisible(showDestinationField);
            this.fileDestination.setEnabled(outputIsUsed && cmpEditable && cmpEnabled);
            this.consoleDestination.setEnabled(outputIsUsed && cmpEditable && cmpEnabled);
            this.destinationBase.setEditable(outputToFile && outputIsUsed && cmpEditable);
            this.destinationBase.setEnabled(outputToFile && outputIsUsed && cmpEnabled);
            this.destinationHelper.setEnabled(outputToFile && outputIsUsed && cmpEnabled && cmpEnabled);
            this.currentNameChoice.setEnabled(outputToFile && outputIsUsed && cmpEditable && cmpEnabled);
            this.proposedNameChoice.setEnabled(outputToFile && outputIsUsed && cmpEditable && cmpEnabled);
            this.newNameChoice.setEnabled(outputToFile && outputIsUsed && !destinationMultiple && cmpEditable && cmpEnabled);
            this.sourcePane.revalidate();
            this.destinationPane.revalidate();
            Container parent = this.sourcePane.getParent();
            if (parent != null) {
                parent.invalidate();
                parent.repaint();
            }
        }
    }

    void displayHelper(boolean forSource) {
        JPanel parent;
        JFileChooser chooser = new JFileChooser();
        chooser.setMultiSelectionEnabled(false);
        chooser.setFileSelectionMode(this.sourceMultiFile ? 1 : 0);
        chooser.setDialogTitle(this.sourceMultiFile ? "Select a directory" : "Select a file");
        String defaultDirKey = forSource ? DEFAULT_CHOOSER_SRC_DIRECTORY : DEFAULT_CHOOSER_DEST_DIRECTORY;
        File currentFile = this.getFile(forSource ? this.sourceBase : this.destinationBase);
        if (currentFile != null && this.sourceMultiFile && currentFile.isFile()) {
            currentFile = currentFile.getParentFile();
        }
        if (currentFile == null) {
            try {
                String initialPath = this.setts.getFileProperty(defaultDirKey, null, true);
                if (initialPath != null) {
                    chooser.setCurrentDirectory(new File(initialPath));
                }
            }
            catch (Exception e) {
                log.warn((Object)"Cannot configure chooser current directory", (Throwable)e);
            }
        } else {
            chooser.setSelectedFile(currentFile);
        }
        JPanel jPanel = parent = forSource ? this.sourcePane : this.destinationPane;
        if (chooser.showOpenDialog(parent) == 0) {
            File selected = chooser.getSelectedFile();
            String path = selected == null ? "" : selected.getAbsolutePath();
            try {
                this.setts.setFileProperty(defaultDirKey, chooser.getCurrentDirectory().getAbsolutePath());
            }
            catch (Exception e) {
                log.warn((Object)"Cannot persist chooser current directory", (Throwable)e);
            }
            if (forSource) {
                this.sourceBase.setText(path);
            } else {
                this.destinationBase.setText(path);
            }
        }
    }

    protected void synchronizeEditableState() {
        this.updateGui();
    }

    public void edit(Object objToEdit) {
        this.pipeline = (Pipeline)objToEdit;
        super.edit(objToEdit);
    }

    public Object getEditedObject() {
        return this.pipeline;
    }

    public JComponent getEditorComponent() {
        return this.getSourcePanel();
    }

    public void updateModel() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("<<< Update model of pipeline: " + this.pipeline));
        }
        if (this.pipeline != null && this.sourcePane != null) {
            this.pipeline.setSourceMultiFile(this.sourceMultiFile);
            this.pipeline.setOutputDestination(this.outputDestination);
            this.pipeline.setOutputNameChoice(this.outputNameChoice);
            this.pipeline.setSource(this.getFile(this.sourceBase));
            this.pipeline.setIncludesPattern(this.includePattern.getText());
            this.pipeline.setExcludesPattern(this.excludePattern.getText());
            this.pipeline.setOutputFile(this.getFile(this.destinationBase));
        }
    }

    private File getFile(JTextField field) {
        String text = field.getText();
        if (text == null || text.trim().equals("")) {
            return null;
        }
        return new File(text);
    }

    private String getString(File fil) {
        return fil == null ? "" : fil.getAbsolutePath();
    }

    public void updateView() {
        if (this.sourcePane != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)(">>> Update view for pipeline: " + this.pipeline));
            }
            if (this.pipeline == null) {
                this.setEnabled(false);
                this.sourceBase.setText("");
                this.includePattern.setText("");
                this.excludePattern.setText("");
                this.destinationBase.setText("");
            } else {
                this.setEnabled(true);
                this.setMultiFile(this.pipeline.isSourceMultiFile());
                this.setOutputDestination(this.pipeline.getOutputDestination());
                this.setOutputNameChoice(this.pipeline.getOutputNameChoice());
                this.sourceBase.setText(this.getString(this.pipeline.getSource()));
                this.includePattern.setText(this.pipeline.getIncludesPattern());
                this.excludePattern.setText(this.pipeline.getExcludesPattern());
                this.destinationBase.setText(this.getString(this.pipeline.getOutputFile()));
            }
        }
    }

    public void checkCardinality() {
        if (this.sourcePane != null && this.pipeline != null && this.currentOutputCardinality != this.pipeline.getOutputCardinality()) {
            this.updateGui();
        }
    }

    public JComponent getObjectComponent() {
        return this.getSourcePanel();
    }

    private static class TextfieldFileDropAdapter
    implements FileDropListener.FileDropTarget {
        private JTextField tf;
        private boolean directoryOnly;

        public TextfieldFileDropAdapter(JTextField field) {
            this.tf = field;
            FileDropListener lis = new FileDropListener((FileDropListener.FileDropTarget)this, (FileType[])null);
            lis.registerToComponent((Component)this.tf);
        }

        public void setDirectoryOnly(boolean newDirectoryOnly) {
            this.directoryOnly = newDirectoryOnly;
        }

        public void filesDropped(File[] files, int dropAction) {
            if (files != null && files.length > 0) {
                System.out.println(">>> " + files.length + " file dropped = " + Arrays.toString(files));
                this.fileDropped(files[0]);
            }
        }

        private void fileDropped(File f) {
            if (f != null && this.directoryOnly && !f.isDirectory()) {
                f = f.getParentFile();
            }
            if (f != null) {
                this.tf.setText(f.getAbsolutePath());
            }
        }
    }
}

