/*
 * Decompiled with CFR 0.152.
 */
package net.sf.filePiper;

import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import net.sf.filePiper.gui.PiperMainPanel;
import net.sf.filePiper.model.ToolModel;
import net.sf.sfac.gui.ExceptionDialog;
import net.sf.sfac.gui.framework.ActionRepository;
import net.sf.sfac.gui.framework.ApplicationFrame;
import net.sf.sfac.gui.framework.LookAndFeelHelper;
import net.sf.sfac.gui.framework.SharedResources;
import net.sf.sfac.gui.profiles.ProfilesController;
import net.sf.sfac.setting.ProfilesClient;
import net.sf.sfac.setting.Settings;
import net.sf.sfac.setting.SettingsImpl;
import org.apache.log4j.Logger;
import org.apache.log4j.xml.DOMConfigurator;

public class PiperTool {
    private static Logger log = Logger.getLogger(PiperTool.class);
    private ToolModel mainModel;
    private ApplicationFrame frame;
    private PiperMainPanel mainPanel;

    public static void setupLogging() {
        try {
            DOMConfigurator.configure((URL)new File("log4j.xml").toURI().toURL());
        }
        catch (MalformedURLException mue) {
            throw new IllegalStateException("Invalid log4j configuration file URL", mue);
        }
    }

    private void buildMainFrame(File configFile) {
        try {
            log.debug((Object)"Building model ...");
            SettingsImpl sett = new SettingsImpl(configFile, "Configuration file for the PiperTool");
            sett.load();
            this.mainModel = new ToolModel((Settings)sett);
            log.debug((Object)"Building GUI ...");
            ActionRepository repo = new ActionRepository();
            LookAndFeelHelper lookHelper = new LookAndFeelHelper((Settings)sett);
            lookHelper.createActions(repo, "View/Look & Feel", "d/x9", null);
            this.frame = new ApplicationFrame("File Piper", (Settings)sett);
            this.frame.setIconImage(SharedResources.getIcon((String)"frameIcon.gif").getImage());
            this.mainPanel = new PiperMainPanel(this.mainModel, repo);
            new ProfilesController((ProfilesClient)this.mainPanel, repo);
            log.debug((Object)"Show main frame ...");
            lookHelper.setRootUiComponent((Component)this.frame);
            this.frame.getContentPane().add((Component)this.mainPanel, "Center");
            this.frame.addWindowListener((WindowListener)new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    PiperTool.this.exit();
                }
            });
            this.frame.createViewToolbarAction(repo, "View", "d/a1", null);
            this.frame.setJMenuBar(repo.createMenuBar());
            this.frame.setToolBar(repo.createToolBar());
            this.frame.setVisible(true);
        }
        catch (Exception e) {
            ExceptionDialog.showExceptionDialog((Component)this.frame, (String)"Fatal Error", (String)"Unable to start application", (Throwable)e);
        }
    }

    protected void exit() {
        this.mainPanel.exit();
    }

    public static void main(String[] args) {
        PiperTool.setupLogging();
        SharedResources.addBaseImageLocation((String)"/net/sf/filePiper/images");
        int nbrArgs = args == null ? 0 : args.length;
        String configFileName = nbrArgs > 0 ? args[0] : "PiperTool.properties";
        File configFile = new File(configFileName);
        log.info((Object)("Starting Piper using config file: " + configFile.getAbsolutePath()));
        PiperTool theTool = new PiperTool();
        theTool.buildMainFrame(configFile);
    }
}

