package net.sf.filePiper.model;


import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import net.sf.sfac.setting.Settings;
import net.sf.sfac.setting.SubSettingsProxy;

import org.apache.log4j.Logger;

import sun.misc.Service;


public class ToolModel {


    private static Logger log = Logger.getLogger(ToolModel.class);

    private Settings sett;
    private SubSettingsProxy pipelineSettings;
    private Pipeline pipeline;
    private List<FileProcessor> availableProcessors;
    private List<ChangeListener> listeners;


    public ToolModel(Settings setts) {
        sett = setts;
        pipelineSettings = new SubSettingsProxy(sett, "currentPipeline");
        log.info("Initialize pipeline from settings");
        pipeline = new Pipeline(pipelineSettings);
    }


    public Settings getSettings() {
        return sett;
    }


    public Settings getPipelineSettings() {
        return pipelineSettings;
    }


    public void updatePipelineSettings(Settings profile) {
        pipelineSettings.clear();
        pipelineSettings.copyValues(profile);
        log.info("Copy pipeline settings from profile: " + profile.getStringProperty(SubSettingsProxy.SUB_SETTING_NAME, "???"));
        pipeline.reset();
        fireDataChanged();
    }


    public Pipeline getPipeline() {
        return pipeline;
    }


    @SuppressWarnings("unchecked")
    public List<FileProcessor> getAvailableProcessors() {
        if (availableProcessors == null) {
            availableProcessors = new ArrayList<FileProcessor>();
            log.info("SPI retrieving of all FileProcessor");
            Iterator<FileProcessor> plugInDefs = Service.providers(FileProcessor.class, getClass().getClassLoader());
            while (plugInDefs.hasNext()) {
                FileProcessor processor = plugInDefs.next();
                log.info("  * FileProcessor = " + processor.getClass());
                availableProcessors.add(processor);
            }
            Collections.sort(availableProcessors, new Comparator<FileProcessor>() {


                public int compare(FileProcessor fp1, FileProcessor fp2) {
                    return fp1.getProcessorName().compareTo(fp2.getProcessorName());
                }

            });
        }
        return availableProcessors;
    }


    public FileProcessor getPrototype(FileProcessor fp) {
        FileProcessor proto = null;
        for (FileProcessor processor : getAvailableProcessors()) {
            if (processor.getClass() == fp.getClass()) {
                proto = processor;
                break;
            }
        }
        return proto;
    }


    public void addChangeListener(ChangeListener l) {
        if (listeners == null) listeners = new ArrayList<ChangeListener>();
        listeners.add(l);
    }


    public void removeChangeListener(ChangeListener l) {
        if (listeners != null) listeners.remove(l);
    }


    public void fireDataChanged() {
        if (listeners != null) {
            ChangeEvent ev = new ChangeEvent(this);
            for (ChangeListener l : listeners) {
                l.stateChanged(ev);
            }
        }
    }


}
