package net.sf.filePiper.gui;


import java.awt.Color;
import java.awt.Dimension;

import javax.swing.JLabel;


public class StatusBar extends JLabel {


    private static final double FACTOR = 0.9;
    private String status;


    public StatusBar() {
        setText(" ");
        setBackground(darker(getBackground()));
        setOpaque(true);
        Dimension preferredSize = getPreferredSize();
        setPreferredSize(new Dimension(200, preferredSize.height));
    }


    public Color darker(Color src) {
        return new Color(Math.max((int) (src.getRed() * FACTOR), 0), Math.max((int) (src.getGreen() * FACTOR), 0), Math.max(
                (int) (src.getBlue() * FACTOR), 0));
    }


    public void setStatus(String newStatus) {
        if (!newStatus.equals(status)) {
            status = newStatus;
            setText(newStatus);
        }
    }

}
