/*
 * Decompiled with CFR 0.152.
 */
package net.sf.filePiper.processors;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.sf.filePiper.model.ExecutionPhase;
import net.sf.filePiper.model.FileProcessor;
import net.sf.filePiper.model.FileProcessorEnvironment;
import net.sf.filePiper.model.InputFileInfo;
import net.sf.filePiper.model.StatusHolder;
import net.sf.sfac.file.FilePathUtils;
import net.sf.sfac.gui.editor.ObjectEditor;
import net.sf.sfac.gui.editor.cmp.ReadOnlyObjectEditor;
import net.sf.sfac.setting.Settings;
import org.apache.log4j.Logger;

public class UnzipProcessor
implements FileProcessor {
    Logger log = Logger.getLogger(UnzipProcessor.class);
    private StatusHolder holder = new StatusHolder(){

        protected String getRunningMessage() {
            StringBuilder sb = new StringBuilder();
            sb.append("Unzipping ");
            this.appendCount(this.getInputFileCount(), "zip", sb);
            sb.append(" into ");
            this.appendCount(this.getOutputFileCount(), "file", sb);
            sb.append(" (");
            this.appendCount(this.getByteCount(), "byte", sb);
            sb.append(")...");
            return sb.toString();
        }

        protected String getDoneMessage() {
            StringBuilder sb = new StringBuilder();
            this.appendCount(this.getInputFileCount(), "zip", sb);
            sb.append(" unzipped in ");
            this.appendCount(this.getOutputFileCount(), "file", sb);
            sb.append(" (");
            this.appendCount(this.getByteCount(), "byte", sb);
            sb.append(").");
            return sb.toString();
        }
    };

    public String getProcessorName() {
        return "Unzip";
    }

    public void init(Settings sett) {
    }

    public int getOutputCardinality(int inputCardinality) {
        return 2;
    }

    public void process(InputStream is, InputFileInfo info, FileProcessorEnvironment env) throws IOException {
        ZipInputStream zipIs = new ZipInputStream(is);
        this.holder.inputFileStarted();
        ZipEntry entry = zipIs.getNextEntry();
        String zipInputPath = info.getInput().getAbsolutePath();
        String zipDirectory = FilePathUtils.getDirectoryPath((String)zipInputPath);
        if (info.getBasePath() == null) {
            info.setBasePath(new File(zipDirectory));
        }
        while (entry != null && env.shouldContinue()) {
            if (!entry.isDirectory()) {
                int len;
                String entryPath = entry.getName();
                File inputFile = new File(zipInputPath + "#" + entryPath);
                String entryParentPath = FilePathUtils.getDirectoryPath((String)entryPath);
                String name = FilePathUtils.getFileName((String)entryPath);
                String extension = FilePathUtils.getExtension((String)name);
                if (extension != null) {
                    name = name.substring(0, name.length() - (extension.length() + 1));
                }
                info.setInput(inputFile);
                info.setProposedPath(FilePathUtils.concatPaths((String)zipDirectory, (String)entryParentPath));
                info.setProposedName(name);
                info.setProposedExtension(extension);
                OutputStream os = env.getOutputStream(info);
                this.holder.outputFileStarted();
                byte[] buffer = new byte[1024];
                while ((len = zipIs.read(buffer)) > 0 && env.shouldContinue()) {
                    os.write(buffer, 0, len);
                    this.holder.bytesProcessed(len);
                }
                os.close();
            }
            entry = zipIs.getNextEntry();
        }
    }

    public ObjectEditor getEditor() {
        return new ReadOnlyObjectEditor("Unzip all the input files.");
    }

    public void startBatch(FileProcessorEnvironment env) {
        this.holder.reset(ExecutionPhase.STARTING);
    }

    public void endBatch(FileProcessorEnvironment env) {
        this.holder.setCurrentPhase(env.getCurrentPhase());
    }

    public String getStatusMessage() {
        return this.holder.getStatusMessage();
    }
}

