/*
 * Decompiled with CFR 0.152.
 */
package net.sf.filePiper.processors;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.filePiper.model.ExecutionPhase;
import net.sf.filePiper.model.FileProcessor;
import net.sf.filePiper.model.FileProcessorEnvironment;
import net.sf.filePiper.model.InputFileInfo;
import net.sf.filePiper.model.Pipeline;
import net.sf.filePiper.model.StatusHolder;
import net.sf.sfac.editor.EditorConfig;
import net.sf.sfac.gui.editor.EditorFactory;
import net.sf.sfac.gui.editor.ObjectEditor;
import net.sf.sfac.setting.Settings;
import net.sf.sfac.string.CharIterator;
import net.sf.sfac.string.ReaderCharIterator;
import net.sf.sfac.string.StringCharIterator;
import net.sf.sfac.string.StringUtils;

public class SearchProcessor
implements FileProcessor {
    private static final String SEARCH_STRING = "search.string";
    private static final String SEARCH_BY_LINE = "search.by.line";
    private static final String SEARCH_METHOD = "search.method";
    private static final String SEARCH_OUTPUT = "search.output";
    private Matcher m;
    private Settings sett;
    private BufferedWriter out;
    private StatusHolder holder = new StatusHolder(){

        protected String getRunningMessage() {
            StringBuilder sb = new StringBuilder();
            this.appendLineOrByteCount(this.getByteCount(), this.getLineCount(), sb);
            sb.append(" processed from ");
            this.appendCount(this.getInputFileCount(), "file", sb);
            sb.append(" (");
            this.appendCount(this.getOutputFileCount(), "file", sb);
            sb.append(" found)...");
            return sb.toString();
        }

        protected String getDoneMessage() {
            StringBuilder sb = new StringBuilder();
            this.appendLineOrByteCount(this.getByteCount(), this.getLineCount(), sb);
            sb.append(" searched from ");
            this.appendCount(this.getInputFileCount(), "file", sb);
            sb.append(" (");
            this.appendCount(this.getOutputFileCount(), "file", sb);
            sb.append(" found).");
            return sb.toString();
        }
    };

    public String getProcessorName() {
        return "Search for expression";
    }

    public String getProcessorDescription() {
        return "Search a string in files and generate a text report of files/lines matched.";
    }

    @EditorConfig(label="Find", index=0)
    public String getSearchString() {
        return this.sett.getStringProperty(SEARCH_STRING, "");
    }

    public void setSearchString(String searchString) {
        this.sett.setStringProperty(SEARCH_STRING, searchString);
    }

    @EditorConfig(label="Search line by line", index=2)
    public boolean getSearchByLine() {
        return this.sett.getBooleanProperty(SEARCH_BY_LINE, true);
    }

    public void setSearchByLine(boolean byLine) {
        this.sett.setBooleanProperty(SEARCH_BY_LINE, byLine);
    }

    @EditorConfig(label="Matching method", index=1)
    public SearchMethod getSearchMethod() {
        return (SearchMethod)this.sett.getEnumProperty(SEARCH_METHOD, (Enum)SearchMethod.LITTERAL);
    }

    public void setSearchMethod(SearchMethod method) {
        this.sett.setEnumProperty(SEARCH_METHOD, (Enum)method);
    }

    @EditorConfig(label="Output Type", index=3)
    public OutputType getOutputType() {
        return (OutputType)this.sett.getEnumProperty(SEARCH_OUTPUT, (Enum)OutputType.REPORT);
    }

    public void setOutputType(OutputType type) {
        this.sett.setEnumProperty(SEARCH_OUTPUT, (Enum)type);
    }

    public void init(Settings settgns) {
        this.sett = settgns;
    }

    public void startBatch(FileProcessorEnvironment env) throws IOException {
        this.m = null;
        this.holder.reset(ExecutionPhase.STARTING);
        Pipeline line = env.getPipeline();
        File dir = line.getSource();
        if (dir.isFile()) {
            dir = dir.getAbsoluteFile().getParentFile();
        }
        InputFileInfo info = new InputFileInfo(dir, new File(dir, "SearchResult.txt"));
        OutputStream os = env.getOutputStream(info);
        this.out = new BufferedWriter(new OutputStreamWriter(os));
        if (this.getOutputType() == OutputType.REPORT) {
            this.out.write("Search ");
            this.out.write(this.getSearchMethod().toString());
            this.out.write(" for: ");
            this.out.write(this.getSearchString());
            this.out.newLine();
            this.out.write(this.getSearchByLine() ? "Line by line" : "In file as a whole");
            this.out.newLine();
            if (line.isSourceMultiFile()) {
                String excludes;
                this.out.write("In files below ");
                this.out.write(dir.getAbsolutePath());
                this.out.newLine();
                String includes = line.getIncludesPattern();
                if (includes != null && !includes.trim().equals("")) {
                    this.out.write("Including ");
                    this.out.write(includes);
                    this.out.newLine();
                }
                if ((excludes = line.getExcludesPattern()) != null && !excludes.trim().equals("")) {
                    this.out.write("Excluding ");
                    this.out.write(excludes);
                    this.out.newLine();
                }
            } else {
                this.out.write("In file ");
                this.out.write(line.getSource().getAbsolutePath());
                this.out.newLine();
            }
            this.out.write("---------------------------------------------------------------------------------");
            this.out.newLine();
        }
    }

    public void process(InputStream is, InputFileInfo info, FileProcessorEnvironment env) throws IOException {
        BufferedReader in = new BufferedReader(new InputStreamReader(is));
        this.process(in, info, env);
    }

    public void process(BufferedReader in, InputFileInfo info, FileProcessorEnvironment env) throws IOException {
        this.holder.inputFileStarted();
        if (this.getSearchByLine()) {
            this.searchLineByLine(in, info, env);
        } else {
            this.searchWholeFile(in, info, env);
        }
    }

    private void searchLineByLine(BufferedReader in, InputFileInfo info, FileProcessorEnvironment env) throws IOException {
        String line;
        String searchString = this.getSearchString();
        SearchMethod method = this.getSearchMethod();
        OutputType outType = this.getOutputType();
        boolean firstMatch = true;
        int lineCount = 0;
        while ((line = in.readLine()) != null && env.shouldContinue()) {
            ++lineCount;
            boolean found = false;
            switch (method) {
                case LITTERAL: {
                    found = line.contains(searchString);
                    break;
                }
                case CASE_INSENSITIVE: {
                    found = StringUtils.matchString((String)searchString, (CharIterator)new StringCharIterator(line), (boolean)true);
                    break;
                }
                case REG_EXPR: {
                    found = this.regExprContains(line, searchString);
                    break;
                }
                case LENIENT: {
                    found = StringUtils.matchPattern((String)searchString, (CharIterator)new StringCharIterator(line));
                    break;
                }
                default: {
                    throw new IllegalStateException("Unimplemented search method: " + (Object)((Object)method));
                }
            }
            if (found) {
                if (firstMatch) {
                    this.holder.outputFileStarted();
                    if (outType == OutputType.REPORT) {
                        this.out.newLine();
                        this.out.write("File ");
                        this.out.write(info.getInput().getAbsolutePath());
                        this.out.newLine();
                    } else if (outType == OutputType.LINES) {
                        this.out.write(info.getInput().getAbsolutePath());
                        this.out.newLine();
                    }
                }
                if (outType == OutputType.REPORT) {
                    this.out.write("    at line ");
                    this.out.write(String.valueOf(lineCount));
                    this.out.write(": ");
                    this.out.write(line);
                    this.out.newLine();
                } else if (outType == OutputType.LINES) {
                    this.out.write(line);
                    this.out.newLine();
                }
                this.out.flush();
                firstMatch = false;
            }
            this.holder.linesProcessed(1L);
        }
    }

    private boolean regExprContains(String line, String searchString) {
        if (this.m == null) {
            Pattern p = Pattern.compile(searchString);
            this.m = p.matcher(line);
        } else {
            this.m.reset(line);
        }
        return this.m.find();
    }

    private void searchWholeFile(BufferedReader in, InputFileInfo info, FileProcessorEnvironment env) throws IOException {
        String searchString = this.getSearchString();
        SearchMethod method = this.getSearchMethod();
        OutputType outType = this.getOutputType();
        if (outType == OutputType.LINES) {
            throw new IllegalArgumentException("Output type 'Lines' is only available when searching line by line.");
        }
        boolean found = false;
        ReaderCharIterator charIterator = null;
        String contentString = null;
        if (env.shouldContinue()) {
            switch (method) {
                case LITTERAL: {
                    charIterator = new ReaderCharIterator((Reader)in);
                    found = StringUtils.matchString((String)searchString, (CharIterator)charIterator, (boolean)false);
                    break;
                }
                case CASE_INSENSITIVE: {
                    charIterator = new ReaderCharIterator((Reader)in);
                    found = StringUtils.matchString((String)searchString, (CharIterator)charIterator, (boolean)true);
                    break;
                }
                case REG_EXPR: {
                    contentString = this.getReaderContent(in);
                    found = this.regExprContains(contentString, searchString);
                    break;
                }
                case LENIENT: {
                    charIterator = new ReaderCharIterator((Reader)in);
                    found = StringUtils.matchPattern((String)searchString, (CharIterator)charIterator);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unimplemented search method: " + (Object)((Object)method));
                }
            }
        }
        if (charIterator != null) {
            this.holder.bytesProcessed(charIterator.getProcessedCharCount());
        }
        if (contentString != null) {
            this.holder.bytesProcessed(contentString.length());
        }
        if (found && env.shouldContinue()) {
            this.holder.outputFileStarted();
            if (outType == OutputType.REPORT) {
                this.out.write("File ");
            }
            this.out.write(info.getInput().getAbsolutePath());
            this.out.newLine();
            this.out.flush();
        }
    }

    private String getReaderContent(BufferedReader in) throws IOException {
        int readCount;
        char[] charBuffer = new char[1024];
        StringBuffer sb = new StringBuffer();
        while ((readCount = in.read(charBuffer)) > 0) {
            sb.append(charBuffer, 0, readCount);
        }
        return sb.toString();
    }

    public void endBatch(FileProcessorEnvironment env) throws IOException {
        if (this.getOutputType() == OutputType.REPORT) {
            this.out.newLine();
            this.out.write("    found ");
            this.out.write(String.valueOf(this.holder.getOutputFileCount()));
            this.out.write(" file");
            if (this.holder.getOutputFileCount() > 1) {
                this.out.write("s");
            }
            this.out.write(" out of ");
            this.out.write(String.valueOf(this.holder.getInputFileCount()));
            this.out.newLine();
        }
        this.out.close();
        this.holder.setCurrentPhase(env.getCurrentPhase());
    }

    public String getStatusMessage() {
        return this.holder.getStatusMessage();
    }

    public int getOutputCardinality(int inputCardinality) {
        return 1;
    }

    public ObjectEditor getEditor() {
        ObjectEditor ed = EditorFactory.getInstance().createEditor(this.getClass());
        ed.setProperty("label", null);
        ed.setProperty("description", (Object)this.getProcessorDescription());
        return ed;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum OutputType {
        REPORT("Report"),
        LINES("Lines"),
        FILE_NAMES("File Names");

        private String text;

        private OutputType(String txt) {
            this.text = txt;
        }

        public String toString() {
            return this.text;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum SearchMethod {
        LITTERAL("Litteral"),
        CASE_INSENSITIVE("Case Insensitive"),
        REG_EXPR("Regular Expr."),
        LENIENT("Lenient");

        private String text;

        private SearchMethod(String txt) {
            this.text = txt;
        }

        public String toString() {
            return this.text;
        }
    }
}

