/*
 * Decompiled with CFR 0.152.
 */
package net.sf.filePiper.processors;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.filePiper.model.FileProcessorEnvironment;
import net.sf.filePiper.model.OneToOneTextFileProcessor;
import net.sf.sfac.editor.EditorConfig;

public class ReplaceProcessor
extends OneToOneTextFileProcessor {
    private static final String REPLACED_STRING = "replaced.string";
    private static final String REPLACEMENT_STRING = "replacement.string";
    private static final String REPLACEMENT_TYPE = "replacement.by.line";
    private static final String SEARCH_METHOD = "search.method";

    public String getProcessorName() {
        return "Replace all";
    }

    public String getProcessorDescription() {
        return "<html>Replace all occurences of a string by another<br>(allows regular experssions like in String.replaceAll(...))</html>";
    }

    @EditorConfig(label="Find", index=0)
    public String getReplaced() {
        return this.getSettings().getStringProperty(REPLACED_STRING, "");
    }

    public void setReplaced(String newReplaced) {
        this.getSettings().setStringProperty(REPLACED_STRING, newReplaced);
    }

    @EditorConfig(label="Matching method", index=1)
    public SearchMethod getSearchMethod() {
        return (SearchMethod)this.getSettings().getEnumProperty(SEARCH_METHOD, (Enum)SearchMethod.LITTERAL);
    }

    public void setSearchMethod(SearchMethod method) {
        this.getSettings().setEnumProperty(SEARCH_METHOD, (Enum)method);
    }

    @EditorConfig(label="Replace By", index=2)
    public String getReplacement() {
        return this.getSettings().getStringProperty(REPLACEMENT_STRING, "");
    }

    public void setReplacement(String newReplacement) {
        this.getSettings().setStringProperty(REPLACEMENT_STRING, newReplacement);
    }

    @EditorConfig(label="Process line by line", index=3)
    public boolean getReplacementByLine() {
        return this.getSettings().getBooleanProperty(REPLACEMENT_TYPE, true);
    }

    public void setReplacementByLine(boolean byLine) {
        this.getSettings().setBooleanProperty(REPLACEMENT_TYPE, byLine);
    }

    public String getProposedNameSuffix() {
        return "rplc";
    }

    private int getPatternFlags() {
        switch (this.getSearchMethod()) {
            case LITTERAL: {
                return 16;
            }
            case CASE_INSENSITIVE: {
                return 18;
            }
        }
        return 0;
    }

    public void process(BufferedReader in, BufferedWriter out, FileProcessorEnvironment env) throws IOException {
        boolean regExp = this.getSearchMethod() == SearchMethod.REG_EXPR;
        Pattern replacedPattern = Pattern.compile(this.getReplaced(), this.getPatternFlags());
        String replacement = this.getReplacement();
        if (this.getReplacementByLine()) {
            String line;
            while ((line = in.readLine()) != null && env.shouldContinue()) {
                out.write(this.replace(line, replacedPattern, replacement, regExp));
                out.newLine();
                this.linesProcessed(1);
            }
        } else {
            int readCount;
            char[] charBuffer = new char[1024];
            StringBuilder sb = new StringBuilder();
            while ((readCount = in.read(charBuffer)) > 0 && env.shouldContinue()) {
                sb.append(charBuffer, 0, readCount);
            }
            String fileContent = sb.toString();
            if (env.shouldContinue()) {
                String replacedFileContent = this.replace(fileContent, replacedPattern, replacement, regExp);
                out.write(replacedFileContent);
            }
            this.bytesProcessed(fileContent.length());
        }
    }

    private String replace(String src, Pattern replacedPattern, String replacement, boolean regExp) {
        if (regExp) {
            return replacedPattern.matcher(src).replaceAll(replacement);
        }
        return replacedPattern.matcher(src).replaceAll(Matcher.quoteReplacement(replacement.toString()));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum SearchMethod {
        LITTERAL("Litteral"),
        CASE_INSENSITIVE("Case Insensitive"),
        REG_EXPR("Regular Expr.");

        private String text;

        private SearchMethod(String txt) {
            this.text = txt;
        }

        public String toString() {
            return this.text;
        }
    }
}

