/*
 * Decompiled with CFR 0.152.
 */
package net.sf.filePiper.processors;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import net.sf.filePiper.model.ExecutionPhase;
import net.sf.filePiper.model.FileProcessor;
import net.sf.filePiper.model.FileProcessorEnvironment;
import net.sf.filePiper.model.InputFileInfo;
import net.sf.filePiper.model.Pipeline;
import net.sf.filePiper.model.StatusHolder;
import net.sf.sfac.gui.editor.ObjectEditor;
import net.sf.sfac.gui.editor.cmp.ReadOnlyObjectEditor;
import net.sf.sfac.setting.Settings;

public class ListFilesProcessor
implements FileProcessor {
    private BufferedWriter out;
    private StatusHolder holder = new StatusHolder(){

        protected String getRunningMessage() {
            StringBuilder sb = new StringBuilder();
            sb.append("Listing ");
            this.appendCount(this.getInputFileCount(), "file", sb);
            sb.append("...");
            return sb.toString();
        }

        protected String getDoneMessage() {
            StringBuilder sb = new StringBuilder();
            this.appendCount(this.getInputFileCount(), "file", sb);
            sb.append(" listed.");
            return sb.toString();
        }
    };

    public String getProcessorName() {
        return "List files";
    }

    public void init(Settings settgns) {
    }

    public void startBatch(FileProcessorEnvironment env) throws IOException {
        this.holder.reset(ExecutionPhase.STARTING);
        Pipeline line = env.getPipeline();
        File dir = line.getSource();
        if (dir.isFile()) {
            dir = dir.getAbsoluteFile().getParentFile();
        }
        InputFileInfo info = new InputFileInfo(dir, new File(dir, "FileList.txt"));
        OutputStream os = env.getOutputStream(info);
        this.out = new BufferedWriter(new OutputStreamWriter(os));
        if (line.isSourceMultiFile()) {
            String excludes;
            this.out.write("Files in ");
            this.out.write(dir.getAbsolutePath());
            this.out.newLine();
            String includes = line.getIncludesPattern();
            if (includes != null && !includes.trim().equals("")) {
                this.out.write("Including ");
                this.out.write(includes);
                this.out.newLine();
            }
            if ((excludes = line.getExcludesPattern()) != null && !excludes.trim().equals("")) {
                this.out.write("Excluding ");
                this.out.write(excludes);
                this.out.newLine();
            }
        } else {
            this.out.write("File ");
            this.out.write(line.getSource().getAbsolutePath());
            this.out.newLine();
        }
    }

    public void process(InputStream is, InputFileInfo info, FileProcessorEnvironment env) throws IOException {
        this.holder.inputFileStarted();
        this.out.write("    ");
        this.out.write(info.getInputRelativePath());
        this.out.newLine();
    }

    public void endBatch(FileProcessorEnvironment env) throws IOException {
        this.out.write("        = ");
        this.out.write(String.valueOf(this.holder.getInputFileCount()));
        this.out.write(" file");
        if (this.holder.getInputFileCount() > 1) {
            this.out.write("s");
        }
        this.out.write(".");
        this.out.newLine();
        this.out.close();
        this.out = null;
        this.holder.setCurrentPhase(env.getCurrentPhase());
    }

    public String getStatusMessage() {
        return this.holder.getStatusMessage();
    }

    public int getOutputCardinality(int inputCardinality) {
        return 1;
    }

    public ObjectEditor getEditor() {
        return new ReadOnlyObjectEditor("List files of a directory");
    }
}

