/*
 * Decompiled with CFR 0.152.
 */
package net.sf.filePiper.processors;

import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import net.sf.filePiper.model.FileProcessorEnvironment;
import net.sf.filePiper.model.InputFileInfo;
import net.sf.filePiper.model.OneToOneByteFileProcessor;
import net.sf.sfac.editor.EditorConfig;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ImageSizerProcessor
extends OneToOneByteFileProcessor {
    private static final String TARGET_SIZE = "image.target.size";
    private static final String TARGET_FORMAT = "image.target.format";
    private static Log log = LogFactory.getLog(ImageSizerProcessor.class);

    public String getProcessorName() {
        return "Image Sizer";
    }

    public String getProcessorDescription() {
        return "<html>Resize images so that the largest image dimension<br>don't exceed the given size (in pixels).</html>";
    }

    @EditorConfig(label="Image bigger size (pixels)")
    public int getTargetSize() {
        return this.getSettings().getIntProperty(TARGET_SIZE, 400);
    }

    public void setTargetSize(int newSize) {
        this.getSettings().setIntProperty(TARGET_SIZE, newSize);
    }

    @EditorConfig(label="Target image format")
    public ImageFormat getTargetFormat() {
        return (ImageFormat)this.getSettings().getEnumProperty(TARGET_FORMAT, (Enum)ImageFormat.jpg);
    }

    public void setTargetFormat(ImageFormat newFormat) {
        this.getSettings().setEnumProperty(TARGET_FORMAT, (Enum)newFormat);
    }

    public String getProposedNameSuffix() {
        return "sized";
    }

    protected void setProposedFilePath(InputFileInfo info) {
        super.setProposedFilePath(info);
        info.setProposedExtension(this.getTargetFormat().name());
    }

    public void process(InputStream is, OutputStream os, FileProcessorEnvironment env) throws IOException {
        BufferedImage img = ImageIO.read(is);
        int width = img.getWidth(null);
        int height = img.getHeight(null);
        int targetSize = this.getTargetSize();
        this.bytesProcessed(width * height);
        if (!env.shouldContinue()) {
            return;
        }
        if (width > targetSize || height > targetSize) {
            int targetHeight;
            int targetWidth;
            if (width > height) {
                targetWidth = targetSize;
                targetHeight = (int)((double)targetSize / (double)width * (double)height);
            } else {
                targetWidth = (int)((double)targetSize / (double)height * (double)width);
                targetHeight = targetSize;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Resize image " + this.getCurrentInputFileInfo().getInputRelativePath() + " from " + width + " x " + height + " to " + targetWidth + " x " + targetHeight));
            }
            BufferedImage targetImg = new BufferedImage(targetWidth, targetHeight, 1);
            Graphics g = targetImg.getGraphics();
            g.drawImage(img, 0, 0, targetWidth, targetHeight, 0, 0, width, height, null);
            if (!env.shouldContinue()) {
                return;
            }
            ImageIO.write((RenderedImage)targetImg, this.getTargetFormat().name(), os);
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("No resize for image " + this.getCurrentInputFileInfo().getInputRelativePath() + " at " + width + " x " + height));
            }
            if (!env.shouldContinue()) {
                return;
            }
            ImageIO.write((RenderedImage)img, this.getTargetFormat().name(), os);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ImageFormat {
        jpg,
        png,
        gif;

    }
}

