/*
 * Decompiled with CFR 0.152.
 */
package net.sf.filePiper.processors;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import net.sf.filePiper.gui.SizeAndUnitEditor;
import net.sf.filePiper.model.ExecutionPhase;
import net.sf.filePiper.model.FileProcessor;
import net.sf.filePiper.model.FileProcessorEnvironment;
import net.sf.filePiper.model.InputFileInfo;
import net.sf.filePiper.model.StatusHolder;
import net.sf.filePiper.processors.SizeAndUnit;
import net.sf.sfac.gui.editor.ObjectEditor;
import net.sf.sfac.setting.Settings;

public class ChunkProcessor
implements FileProcessor,
SizeAndUnit {
    private static final String CHUNK_SIZE = "chunk.size";
    private static final String CHUNK_UNITS = "chunk.units";
    private Settings setts;
    private StatusHolder holder = new StatusHolder(){

        protected String getRunningMessage() {
            StringBuilder sb = new StringBuilder();
            sb.append("Chunking ");
            this.appendCount(this.getInputFileCount(), "file", sb);
            sb.append(" in ");
            sb.append(this.getOutputFileCount());
            sb.append("...");
            return sb.toString();
        }

        protected String getDoneMessage() {
            StringBuilder sb = new StringBuilder();
            this.appendCount(this.getInputFileCount(), "file", sb);
            sb.append(" chunked in ");
            sb.append(this.getOutputFileCount());
            if (this.getInputFileCount() > 1) {
                sb.append(" (");
                this.appendCount(this.getOutputFileCount() / this.getInputFileCount(), "chunk", sb);
                sb.append(" per file)");
            }
            sb.append(".");
            return sb.toString();
        }
    };

    public String getProcessorName() {
        return "Chunk";
    }

    public int getSize() {
        return this.setts.getIntProperty(CHUNK_SIZE, 100);
    }

    public void setSize(int newSize) {
        this.setts.setIntProperty(CHUNK_SIZE, newSize);
    }

    public int getUnits() {
        return this.setts.getIntProperty(CHUNK_UNITS, 1);
    }

    public void setUnits(int newUnits) {
        this.setts.setIntProperty(CHUNK_UNITS, newUnits);
    }

    public ObjectEditor getEditor() {
        return new SizeAndUnitEditor("Chunk the input file into fixed-size files", "Chunk size");
    }

    public int getOutputCardinality(int inputCardinality) {
        return 2;
    }

    public void init(Settings settngs) {
        this.setts = settngs;
    }

    public void process(InputStream is, InputFileInfo info, FileProcessorEnvironment env) throws IOException {
        if (this.getUnits() == 1) {
            this.chunkInLines(is, info, env);
        } else {
            this.chunkInBytes(is, info, env);
        }
    }

    public void chunkInLines(InputStream is, InputFileInfo info, FileProcessorEnvironment env) throws IOException {
        String line;
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        this.holder.inputFileStarted();
        int chunkCount = 0;
        int chunkSize = this.getSize();
        int linesInChunk = 0;
        String initialName = info.getProposedName();
        BufferedWriter bw = null;
        while ((line = br.readLine()) != null && env.shouldContinue()) {
            if (bw == null) {
                info.setProposedName(this.getChunkName(initialName, chunkCount));
                OutputStream os = env.getOutputStream(info);
                bw = new BufferedWriter(new OutputStreamWriter(os));
                this.holder.outputFileStarted();
                ++chunkCount;
                linesInChunk = 0;
            }
            bw.write(line);
            bw.newLine();
            if (++linesInChunk < chunkSize) continue;
            bw.close();
            bw = null;
        }
        if (bw != null) {
            bw.close();
        }
    }

    private String getChunkName(String initialName, int index) {
        StringBuffer sb = new StringBuffer(initialName);
        sb.append('-');
        if (index < 10) {
            sb.append('0');
        }
        if (index < 100) {
            sb.append('0');
        }
        sb.append(index);
        return sb.toString();
    }

    public void chunkInBytes(InputStream is, InputFileInfo info, FileProcessorEnvironment env) throws IOException {
        int readByteCount;
        this.holder.inputFileStarted();
        int chunkCount = 0;
        int chunkSize = this.getSize();
        int bufferSize = chunkSize > 1024 ? 1024 : chunkSize;
        int bytesInChunk = 0;
        String initialName = info.getProposedName();
        byte[] buffer = new byte[bufferSize];
        OutputStream os = this.getOutputStream(info, env, chunkCount, initialName);
        this.holder.outputFileStarted();
        while ((readByteCount = is.read(buffer)) >= 0 && env.shouldContinue()) {
            if (bytesInChunk + readByteCount > chunkSize) {
                int i = chunkSize - bytesInChunk;
                os.write(buffer, 0, i);
                os.close();
                os = this.getOutputStream(info, env, ++chunkCount, initialName);
                this.holder.outputFileStarted();
                bytesInChunk = readByteCount - i;
                os.write(buffer, i, bytesInChunk);
                continue;
            }
            os.write(buffer, 0, readByteCount);
            bytesInChunk += readByteCount;
        }
        if (os != null) {
            os.close();
        }
    }

    private OutputStream getOutputStream(InputFileInfo info, FileProcessorEnvironment env, int chunkCount, String initialName) throws IOException {
        info.setProposedName(this.getChunkName(initialName, chunkCount));
        OutputStream os = env.getOutputStream(info);
        return os;
    }

    public void startBatch(FileProcessorEnvironment env) {
        this.holder.reset(ExecutionPhase.STARTING);
    }

    public void endBatch(FileProcessorEnvironment env) {
        this.holder.setCurrentPhase(env.getCurrentPhase());
    }

    public String getStatusMessage() {
        return this.holder.getStatusMessage();
    }
}

