/*
 * Decompiled with CFR 0.152.
 */
package net.sf.filePiper.model;

import net.sf.filePiper.model.ExecutionPhase;

public class StatusHolder {
    private ExecutionPhase currentPhase = ExecutionPhase.NONE;
    private int inputFileCount;
    private int outputFileCount;
    private long lineCount;
    private long byteCount;
    private volatile String lastMessage;

    public void reset(ExecutionPhase newPhase) {
        if (newPhase == null) {
            throw new IllegalArgumentException("Phase cannot be null, use ExecutionPhase.NONE instead");
        }
        this.currentPhase = newPhase;
        this.inputFileCount = 0;
        this.outputFileCount = 0;
        this.lineCount = 0L;
        this.byteCount = 0L;
        this.lastMessage = null;
    }

    public String getStatusMessage() {
        String message = this.lastMessage;
        if (message == null) {
            switch (this.currentPhase) {
                case STARTING: {
                    message = this.getStartingMessage();
                    break;
                }
                case RUNNING: {
                    message = this.getRunningMessage();
                    break;
                }
                case DONE: {
                    message = this.getDoneMessage();
                    break;
                }
                case ABORTED: {
                    message = this.getAbortedMessage();
                    break;
                }
                case ERRORED: {
                    message = this.getErrorMessage();
                    break;
                }
                default: {
                    message = "";
                }
            }
            this.lastMessage = message;
        }
        return message;
    }

    public void setCurrentPhase(ExecutionPhase newPhase) {
        if (newPhase == null) {
            throw new IllegalArgumentException("Phase cannot be null, use ExecutionPhase.NONE instead");
        }
        this.lastMessage = null;
        this.currentPhase = newPhase;
    }

    public void inputFileStarted() {
        this.runningInfoReceived();
        ++this.inputFileCount;
    }

    public void outputFileStarted() {
        this.runningInfoReceived();
        ++this.outputFileCount;
    }

    public void linesProcessed(long nbrLineProcessed) {
        this.runningInfoReceived();
        this.lineCount += nbrLineProcessed;
    }

    public void bytesProcessed(long nbrByteProcessed) {
        this.runningInfoReceived();
        this.byteCount += nbrByteProcessed;
    }

    private void runningInfoReceived() {
        if (this.currentPhase == ExecutionPhase.NONE || this.currentPhase == ExecutionPhase.STARTING) {
            this.currentPhase = ExecutionPhase.RUNNING;
        }
        this.lastMessage = null;
    }

    public ExecutionPhase getCurrentPhase() {
        return this.currentPhase;
    }

    public int getInputFileCount() {
        return this.inputFileCount;
    }

    public int getOutputFileCount() {
        return this.outputFileCount;
    }

    public long getLineCount() {
        return this.lineCount;
    }

    public long getByteCount() {
        return this.byteCount;
    }

    protected String getStartingMessage() {
        return "Waiting for input...";
    }

    protected String getRunningMessage() {
        StringBuilder sb = new StringBuilder();
        this.appendLineOrByteCount(this.byteCount, this.lineCount, sb);
        sb.append(" processed from ");
        this.appendCount(this.inputFileCount, "file", sb);
        sb.append("...");
        return sb.toString();
    }

    protected String getDoneMessage() {
        StringBuilder sb = new StringBuilder();
        this.appendLineOrByteCount(this.byteCount, this.lineCount, sb);
        sb.append(" done from ");
        this.appendCount(this.inputFileCount, "file", sb);
        if (this.inputFileCount > 1) {
            sb.append(" (");
            this.appendLineOrByteCount(this.byteCount / (long)this.inputFileCount, this.lineCount / (long)this.inputFileCount, sb);
            sb.append(" per file)");
        }
        sb.append(".");
        return sb.toString();
    }

    protected String getAbortedMessage() {
        return "Aborted after: " + this.getDoneMessage();
    }

    protected String getErrorMessage() {
        return "Error after: " + this.getDoneMessage();
    }

    protected void appendLineOrByteCount(long bytes, long lines, StringBuilder sb) {
        if (bytes > 0L) {
            this.appendCount(bytes, "byte", sb);
        } else {
            this.appendCount(lines, "line", sb);
        }
    }

    protected void appendCount(long count, String entityName, StringBuilder sb) {
        sb.append(count);
        sb.append(' ');
        sb.append(entityName);
        if (count > 1L) {
            sb.append("s");
        }
    }
}

