/*
 * Decompiled with CFR 0.152.
 */
package net.sf.filePiper.model;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.sf.filePiper.model.FileProcessor;
import net.sf.filePiper.model.PipeComponent;
import net.sf.filePiper.model.PipelineEnd;
import net.sf.filePiper.model.PipelineEnvironment;
import net.sf.filePiper.model.PipelineStart;
import net.sf.filePiper.model.ProcessorThread;
import net.sf.filePiper.processors.HeadProcessor;
import net.sf.sfac.file.FilePathUtils;
import net.sf.sfac.file.InvalidPathException;
import net.sf.sfac.setting.Settings;
import net.sf.sfac.setting.SubSettingsList;
import net.sf.sfac.setting.SubSettingsProxy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Pipeline {
    private static final String SETTING_PROCESSOR_CLASS = "processor.class";
    private static final String SETTING_SOURCE_FILE = "pipeline.source.file";
    private static final String SETTING_SOURCE_MULTI_FILE = "pipeline.source.multi.file";
    private static final String SETTING_SOURCE_INCLUDES = "pipeline.source.includes";
    private static final String SETTING_SOURCE_EXCLUDES = "pipeline.source.excludes";
    private static final String SETTING_OUTPUT_NAME_CHOICE = "pipeline.output.type";
    private static final String SETTING_OUTPUT_FILE = "pipeline.output.file";
    private static final String SETTING_OUTPUT_DESTINATION = "pipeline.output.destination";
    public static final int OUTPUT_NAME_CURRENT = 0;
    public static final int OUTPUT_NAME_PROPOSED = 1;
    public static final int OUTPUT_NAME_NEW = 2;
    public static final int OUTPUT_TO_CONSOLE = 10;
    public static final int OUTPUT_TO_FILE = 11;
    static Log log = LogFactory.getLog(Pipeline.class);
    private List<FileProcessor> processors;
    private Settings sett;
    private SubSettingsList subSettings;
    private boolean sourceMultiFile;
    private File sourceFileOrDirectory;
    private String includesPattern;
    private String excludesPattern;
    private int outputDestination;
    private int outputNameChoice;
    private File outputFileOrDirectory;

    public Pipeline(Settings setts) {
        this.sett = setts;
        this.subSettings = this.sett == null ? null : new SubSettingsList(this.sett, "processor");
        this.processors = new ArrayList<FileProcessor>();
        this.init();
    }

    public void reset() {
        this.subSettings.synchronizeWithSettings();
        this.processors.clear();
        this.init();
    }

    private void init() {
        int nbrProcessor;
        this.sourceMultiFile = this.sett.getBooleanProperty(SETTING_SOURCE_MULTI_FILE, false);
        String sourceFileStr = this.sett.getFileProperty(SETTING_SOURCE_FILE, null);
        this.sourceFileOrDirectory = sourceFileStr == null ? null : new File(sourceFileStr);
        this.includesPattern = this.sett.getStringProperty(SETTING_SOURCE_INCLUDES, null);
        this.excludesPattern = this.sett.getStringProperty(SETTING_SOURCE_EXCLUDES, null);
        this.outputNameChoice = this.sett.getIntProperty(SETTING_OUTPUT_NAME_CHOICE, 1);
        this.outputDestination = this.sett.getIntProperty(SETTING_OUTPUT_DESTINATION, 11);
        String outputFileStr = this.sett.getFileProperty(SETTING_OUTPUT_FILE, null);
        this.outputFileOrDirectory = outputFileStr == null ? null : new File(outputFileStr);
        int n = nbrProcessor = this.subSettings == null ? 0 : this.subSettings.getSize();
        if (nbrProcessor > 0) {
            log.info((Object)("Loading pipeline from settings: " + nbrProcessor + " processors"));
            for (int i = 0; i < nbrProcessor; ++i) {
                Settings subSett = this.subSettings.getSubSettingAt(i);
                String className = subSett.getStringProperty(SETTING_PROCESSOR_CLASS, "net.sf.filePiper.processors.HeadProcessor");
                try {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("  * add " + className));
                    }
                    FileProcessor fp = (FileProcessor)Class.forName(className).newInstance();
                    fp.init(subSett);
                    this.processors.add(fp);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else {
            log.info((Object)"Add default processor for pipeline");
            this.addProcessor(new HeadProcessor());
        }
    }

    public boolean isSourceMultiFile() {
        return this.sourceMultiFile;
    }

    public void setSourceMultiFile(boolean multi) {
        this.sourceMultiFile = multi;
        this.sett.setBooleanProperty(SETTING_SOURCE_MULTI_FILE, this.sourceMultiFile);
    }

    public int getOutputDestination() {
        return this.outputDestination;
    }

    public void setOutputDestination(int newOutputDestination) {
        this.outputDestination = newOutputDestination;
        this.sett.setIntProperty(SETTING_OUTPUT_DESTINATION, this.outputDestination);
    }

    public int getOutputNameChoice() {
        return this.outputNameChoice;
    }

    public void setOutputNameChoice(int newOutputNameChoice) {
        this.outputNameChoice = newOutputNameChoice;
        this.sett.setIntProperty(SETTING_OUTPUT_NAME_CHOICE, this.outputNameChoice);
    }

    public File getSource() {
        return this.sourceFileOrDirectory;
    }

    public void setSource(File newSource) {
        try {
            this.sett.setFileProperty(SETTING_SOURCE_FILE, newSource == null ? null : newSource.getAbsolutePath());
            this.sourceFileOrDirectory = newSource;
        }
        catch (InvalidPathException ipe) {
            log.warn((Object)("Invalid source path: " + newSource), (Throwable)ipe);
        }
    }

    public String getIncludesPattern() {
        return this.includesPattern;
    }

    public void setIncludesPattern(String newIncludesPattern) {
        this.includesPattern = newIncludesPattern;
        this.sett.setStringProperty(SETTING_SOURCE_INCLUDES, this.includesPattern);
    }

    public String getExcludesPattern() {
        return this.excludesPattern;
    }

    public void setExcludesPattern(String newExcludesPattern) {
        this.excludesPattern = newExcludesPattern;
        this.sett.setStringProperty(SETTING_SOURCE_EXCLUDES, this.excludesPattern);
    }

    public File getOutputFile() {
        return this.outputFileOrDirectory;
    }

    public void setOutputFile(File newOutputFile) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Set destination to: " + newOutputFile));
        }
        try {
            this.sett.setFileProperty(SETTING_OUTPUT_FILE, newOutputFile == null ? null : newOutputFile.getAbsolutePath());
            this.outputFileOrDirectory = newOutputFile;
        }
        catch (InvalidPathException ipe) {
            log.warn((Object)("Invalid destination path: " + newOutputFile), (Throwable)ipe);
        }
    }

    public Settings getSettings() {
        return this.sett;
    }

    public void changeProcessorAt(int processorIndex, FileProcessor newProto) {
        FileProcessor odlFp = this.processors.get(processorIndex);
        SubSettingsProxy sub = (SubSettingsProxy)this.subSettings.getSubSettingAt(processorIndex);
        try {
            FileProcessor newFp = (FileProcessor)newProto.getClass().newInstance();
            sub.clear();
            sub.setStringProperty(SETTING_PROCESSOR_CLASS, newFp.getClass().getName());
            newFp.init((Settings)sub);
            log.info((Object)("Edit pipeline at " + processorIndex + ":  replace " + odlFp + " by " + newFp));
            this.processors.set(processorIndex, newFp);
        }
        catch (Exception e) {
            log.error((Object)("Cannot instantiate new FileProcessor of " + newProto.getClass()), (Throwable)e);
        }
    }

    public void removeProcessor(int index) {
        FileProcessor odlFp = this.processors.remove(index);
        this.subSettings.removeSubSettingAt(index);
        log.info((Object)("Remove " + odlFp + " from pipeline at " + index));
    }

    public void addProcessor(FileProcessor fp) {
        this.addProcessor(this.processors.size(), fp);
    }

    public void addProcessor(int index, FileProcessor fp) {
        this.processors.add(index, fp);
        if (this.subSettings != null) {
            Settings sub = this.subSettings.addSubSetting(index);
            sub.setStringProperty(SETTING_PROCESSOR_CLASS, fp.getClass().getName());
            fp.init(sub);
        }
    }

    public void duplicateProcessor(int index) {
        FileProcessor currentProcessor = this.processors.get(index);
        try {
            FileProcessor newProcessor = (FileProcessor)currentProcessor.getClass().newInstance();
            this.processors.add(index, newProcessor);
            if (this.subSettings != null) {
                SubSettingsProxy sourceSub = (SubSettingsProxy)this.subSettings.getSubSettingAt(index);
                SubSettingsProxy newSub = (SubSettingsProxy)this.subSettings.addSubSetting(index);
                newSub.copyValues((Settings)sourceSub);
                newProcessor.init((Settings)newSub);
            }
        }
        catch (Exception e) {
            log.error((Object)("Cannot create duplicate of " + currentProcessor), (Throwable)e);
            throw new IllegalStateException("Unable to create new processor", e);
        }
    }

    public List<FileProcessor> getProcessors() {
        return this.processors;
    }

    public void process(final PipelineEnvironment reporter) throws IOException {
        Thread processThead = new Thread(new Runnable(){

            public void run() {
                try {
                    reporter.startProcessing();
                    Pipeline.this.processAsynch(reporter);
                    reporter.finished(null);
                }
                catch (Exception e) {
                    log.error((Object)"Asynchrone processing stopped by exception", (Throwable)e);
                    reporter.finished(e);
                }
            }
        }, "MainProcessing");
        processThead.start();
    }

    void processAsynch(PipelineEnvironment reporter) throws IOException {
        log.info((Object)"Start file processing batch");
        PipelineStart pipeStart = new PipelineStart(this);
        List<ProcessorThread> threads = this.startThreads(reporter);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Threads created");
        }
        ProcessorThread firstProcessorThread = threads.get(0);
        pipeStart.processInputFiles(firstProcessorThread, reporter);
        firstProcessorThread.finished();
        if (log.isDebugEnabled()) {
            log.debug((Object)"Waiting for all threads");
        }
        for (ProcessorThread pt : threads) {
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("  * Waiting for thread of " + pt));
                }
                pt.join();
            }
            catch (Exception e) {
                log.warn((Object)"Exception during join", (Throwable)e);
            }
        }
        log.info((Object)"File processing batch done");
        reporter.finished(null);
    }

    private List<ProcessorThread> startThreads(PipelineEnvironment reporter) {
        ArrayList<ProcessorThread> threads = new ArrayList<ProcessorThread>();
        FilePathUtils toBaseDir = null;
        if (this.getOutputDestination() == 11 && this.getOutputCardinality() == 2) {
            if (this.outputFileOrDirectory == null) {
                throw new IllegalArgumentException("You must define a destination directory");
            }
            toBaseDir = new FilePathUtils(this.outputFileOrDirectory);
        }
        PipeComponent next = new PipelineEnd(this, toBaseDir, reporter);
        int len = this.processors.size();
        if (len == 0) {
            throw new IllegalStateException("You must define at least one file processor");
        }
        log.info((Object)("Create " + len + " processing threads"));
        for (int i = len - 1; i >= 0; --i) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Create thread for " + this.processors.get(i)));
            }
            ProcessorThread pt = new ProcessorThread(this.processors.get(i), this, next, reporter);
            threads.add(0, pt);
            pt.start();
            next = pt;
        }
        return threads;
    }

    public int getOutputCardinality() {
        int cardinality = this.sourceMultiFile ? 2 : 1;
        for (FileProcessor fp : this.processors) {
            cardinality = fp.getOutputCardinality(cardinality);
        }
        return cardinality;
    }
}

