/*
 * Decompiled with CFR 0.152.
 */
package net.sf.filePiper.model;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import net.sf.filePiper.model.FileProcessorEnvironment;
import net.sf.filePiper.model.InputFileInfo;
import net.sf.filePiper.model.OneToOneByteFileProcessor;
import org.apache.log4j.Logger;

public abstract class OneToOneTextFileProcessor
extends OneToOneByteFileProcessor {
    private Logger log = Logger.getLogger(OneToOneTextFileProcessor.class);

    public void process(InputStream is, InputFileInfo info, FileProcessorEnvironment env) throws IOException {
        try {
            this.inputFileStarted();
            this.setCurrentInputFileInfo(info);
            this.setProposedFilePath(info);
            OutputStream os = env.getOutputStream(info);
            this.process(is, os, env);
            this.setCurrentInputFileInfo(null);
        }
        catch (Exception e) {
            IOException ioe = new IOException("Exception while processing input " + info);
            ioe.initCause(e);
            throw ioe;
        }
    }

    public void process(InputStream is, OutputStream os, FileProcessorEnvironment env) throws Exception {
        BufferedReader rdr = new BufferedReader(new InputStreamReader(is));
        BufferedWriter wr = new BufferedWriter(new OutputStreamWriter(os));
        this.process(rdr, wr, env);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Processor " + this + " closes output stream"));
        }
        wr.close();
    }

    public abstract void process(BufferedReader var1, BufferedWriter var2, FileProcessorEnvironment var3) throws Exception;
}

