/*
 * Decompiled with CFR 0.152.
 */
package net.sf.filePiper.gui.borders;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import net.sf.filePiper.gui.borders.RolloverButton;
import net.sf.sfac.gui.framework.SharedResources;
import net.sf.sfac.gui.layout.MultiBorder;

public class FileProcessorBorder
extends MultiBorder {
    private JComboBox combo;
    private RolloverButton addButton;
    private RolloverButton removeButton;
    private List<Listener> listeners;

    public FileProcessorBorder(ComboBoxModel allChoices) {
        this(new JComboBox(allChoices));
    }

    public FileProcessorBorder(JComboBox choicesCombo) {
        this.combo = choicesCombo;
        this.addButton = new RolloverButton(SharedResources.getIcon((String)"borderAdd.gif"));
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent newE) {
                FileProcessorBorder.this.addPerformed();
            }
        });
        this.removeButton = new RolloverButton(SharedResources.getIcon((String)"borderRemove.gif"));
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent newE) {
                FileProcessorBorder.this.removePerformed();
            }
        });
    }

    public void removePerformed() {
        if (this.listeners != null) {
            for (Listener lis : this.listeners) {
                lis.removeActionPerformed(this);
            }
        }
    }

    public void addPerformed() {
        if (this.listeners != null) {
            for (Listener lis : this.listeners) {
                lis.addActionPerformed(this);
            }
        }
    }

    public void setAddButtonEnabled(boolean enabled) {
        this.addButton.setEnabled(enabled);
    }

    public boolean isAddButtonEnabled() {
        return this.addButton.isEnabled();
    }

    public void setRemoveButtonEnabled(boolean enabled) {
        this.removeButton.setEnabled(enabled);
    }

    public boolean isRemoveButtonEnabled() {
        return this.removeButton.isEnabled();
    }

    protected void registerExtraComponents() {
        this.registerExtraComponent(this.removeButton);
        this.registerExtraComponent(this.addButton);
        this.registerExtraComponent(this.combo);
    }

    protected void layoutExtraComponents(Container cont) {
        Dimension comboDim = this.combo.getPreferredSize();
        Insets borderInsets = this.getUpdatedInsets(cont);
        int posX = this.x + 20;
        int posY = this.y + (borderInsets.top - comboDim.height) / 2;
        this.combo.setBounds(posX, posY, comboDim.width, comboDim.height);
        Dimension buttonDim = this.addButton.getPreferredSize();
        posX = this.x + this.width - 10 - buttonDim.width;
        posY = this.y + (borderInsets.top - buttonDim.height) / 2;
        this.removeButton.setBounds(posX, posY, buttonDim.width, buttonDim.height);
        posX = posX - 4 - buttonDim.width;
        this.addButton.setBounds(posX, posY, buttonDim.width, buttonDim.height);
    }

    protected void updateInsets(Insets insetToUpdate) {
        Dimension comboDim = this.combo.getPreferredSize();
        if (insetToUpdate.top < comboDim.height) {
            insetToUpdate.top = comboDim.height;
        }
        Dimension buttonDim = this.addButton.getPreferredSize();
        if (insetToUpdate.top < buttonDim.height) {
            insetToUpdate.top = buttonDim.height;
        }
        if (insetToUpdate.left < 5) {
            insetToUpdate.left = 5;
        }
        if (insetToUpdate.right < 5) {
            insetToUpdate.right = 5;
        }
        if (insetToUpdate.bottom < 5) {
            insetToUpdate.bottom = 5;
        }
    }

    public void addBorderListsner(Listener lis) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<Listener>();
        }
        this.listeners.add(lis);
    }

    public void removeBorderListsner(Listener lis) {
        if (this.listeners != null) {
            this.listeners.remove(lis);
        }
    }

    public static interface Listener {
        public void removeActionPerformed(FileProcessorBorder var1);

        public void addActionPerformed(FileProcessorBorder var1);
    }
}

