/*
 * Decompiled with CFR 0.152.
 */
package net.sf.filePiper.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import net.sf.filePiper.processors.SizeAndUnit;
import net.sf.sfac.gui.editor.cmp.BaseObjectEditor;

public class SizeAndUnitEditor
extends BaseObjectEditor {
    private String description;
    private String sizeLabelText;
    private int units;
    private SizeAndUnit editedObj;
    private JPanel editorPane;
    private JLabel descriptionLabel;
    private JLabel unitTypeLabel;
    private JLabel sizeLabel;
    private JLabel sizeUnitsLabel;
    private JRadioButton lineUnitChoice;
    private JRadioButton byteUnitChoice;
    private JTextField sizeTextField;

    public SizeAndUnitEditor(String descript, String text) {
        this.description = descript;
        this.sizeLabelText = text;
    }

    private void buildGui() {
        if (this.editorPane == null) {
            this.editorPane = new JPanel(new GridBagLayout());
            String desc = this.getDescription();
            if (desc != null) {
                this.descriptionLabel = new JLabel(desc);
                this.descriptionLabel.setForeground(Color.DARK_GRAY);
                this.editorPane.add((Component)this.descriptionLabel, new GridBagConstraints(0, 0, 4, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            }
            this.unitTypeLabel = new JLabel("Units");
            ButtonGroup radios = new ButtonGroup();
            this.lineUnitChoice = new JRadioButton("Lines");
            this.lineUnitChoice.setSelected(this.units == 1);
            this.lineUnitChoice.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent newE) {
                    SizeAndUnitEditor.this.setUnitChoice(1);
                }
            });
            radios.add(this.lineUnitChoice);
            this.byteUnitChoice = new JRadioButton("Bytes");
            this.byteUnitChoice.setSelected(this.units == 0);
            this.byteUnitChoice.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent newE) {
                    SizeAndUnitEditor.this.setUnitChoice(0);
                }
            });
            radios.add(this.byteUnitChoice);
            this.editorPane.add((Component)this.unitTypeLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 8, 0, 4), 0, 0));
            this.editorPane.add((Component)this.lineUnitChoice, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 4), 0, 0));
            this.editorPane.add((Component)this.byteUnitChoice, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.sizeLabel = new JLabel(this.getSizeLabelText());
            this.sizeTextField = new JTextField(8);
            this.sizeUnitsLabel = new JLabel(this.units == 0 ? "bytes" : "lines");
            this.editorPane.add((Component)this.sizeLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 8, 0, 4), 0, 0));
            this.editorPane.add((Component)this.sizeTextField, new GridBagConstraints(1, 2, 2, 1, 0.0, 0.0, 17, 2, new Insets(2, 0, 0, 4), 0, 0));
            this.editorPane.add((Component)this.sizeUnitsLabel, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 0, 0, 0), 0, 0));
            this.synchronizeEditableState();
        }
    }

    void setUnitChoice(int newUnitChoice) {
        if (this.units != newUnitChoice) {
            this.units = newUnitChoice;
            if (this.byteUnitChoice != null && this.units == 0 && !this.byteUnitChoice.isSelected()) {
                this.byteUnitChoice.setSelected(true);
            }
            if (this.lineUnitChoice != null && this.units == 1 && !this.lineUnitChoice.isSelected()) {
                this.lineUnitChoice.setSelected(true);
            }
            if (this.sizeUnitsLabel != null) {
                this.sizeUnitsLabel.setText(this.units == 0 ? "bytes" : "lines");
            }
        }
    }

    protected void synchronizeEditableState() {
        this.sizeTextField.setEditable(this.isEditable());
        this.sizeTextField.setEnabled(this.isEnabled());
        this.lineUnitChoice.setEnabled(this.isEditable() && this.isEnabled());
        this.byteUnitChoice.setEnabled(this.isEditable() && this.isEnabled());
    }

    public void edit(Object objToEdit) {
        this.editedObj = (SizeAndUnit)objToEdit;
    }

    public Object getEditedObject() {
        return this.editedObj;
    }

    public JComponent getEditorComponent() {
        this.buildGui();
        return this.editorPane;
    }

    public boolean isModified() {
        return false;
    }

    public void updateModel() {
        if (this.editedObj != null && this.editorPane != null) {
            int size = 0;
            String text = this.sizeTextField.getText();
            if (text != null && !(text = text.trim()).equals("")) {
                try {
                    size = Integer.parseInt(text);
                }
                catch (Exception e) {
                    size = 0;
                    this.sizeTextField.setText("0");
                }
            }
            this.editedObj.setSize(size);
            this.editedObj.setUnits(this.units);
        }
    }

    public void updateView() {
        if (this.editorPane != null) {
            if (this.editedObj == null) {
                this.setEnabled(false);
                this.sizeTextField.setText("");
            } else {
                this.setEnabled(true);
                this.sizeTextField.setText(String.valueOf(this.editedObj.getSize()));
                this.setUnitChoice(this.editedObj.getUnits());
            }
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String newDescription) {
        this.description = newDescription;
    }

    public String getSizeLabelText() {
        return this.sizeLabelText;
    }

    public void setSizeLabelText(String newSizeLabelText) {
        this.sizeLabelText = newSizeLabelText;
    }

    public JComponent getObjectComponent() {
        return this.getEditorComponent();
    }
}

