/*
 * Decompiled with CFR 0.152.
 */
package net.sf.filePiper.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JToolBar;
import javax.swing.border.Border;
import net.sf.filePiper.gui.PiperMainPanel;
import net.sf.filePiper.gui.ProfilesComboEditor;
import net.sf.filePiper.model.ToolModel;
import net.sf.sfac.editor.EditorConfig;
import net.sf.sfac.gui.ExceptionDialog;
import net.sf.sfac.gui.cmp.PartialLineBorder;
import net.sf.sfac.gui.editor.EditorOptionsDialog;
import net.sf.sfac.gui.framework.ActionRepository;
import net.sf.sfac.gui.framework.BarChangeListener;
import net.sf.sfac.gui.framework.SharedResources;
import net.sf.sfac.setting.SubSettingsList;
import net.sf.sfac.setting.SubSettingsProxy;
import net.sf.sfac.utils.Comparison;
import org.apache.log4j.Logger;

public class ProfilesController
implements BarChangeListener {
    private static Logger log = Logger.getLogger(ProfilesController.class);
    private ToolModel mainModel;
    private PiperMainPanel mainPanel;
    private JComboBox pipelineCombo;
    private Action restoreProfile;
    private Action renameProfile;
    private Action removeProfile;

    public ProfilesController(ToolModel model, PiperMainPanel pane, ActionRepository repo) {
        this.mainModel = model;
        this.mainPanel = pane;
        this.createActions(repo);
        repo.addBarChangeListener((BarChangeListener)this);
    }

    private void createActions(ActionRepository repo) {
        repo.addAction("storeProfile", "Store profile", "Store current profile", "Profile", "d/a1", "z1", (Icon)SharedResources.getIcon((String)"borderAdd.gif"), (Action)new AbstractAction(){

            public void actionPerformed(ActionEvent ae) {
                ProfilesController.this.storeCurrentProfile();
            }
        });
        this.restoreProfile = repo.addAction("restoreProfile", "Restore profile", "Restore profile values", "Profile", "d/a2", "z1", (Icon)SharedResources.getIcon((String)"refresh.gif"), (Action)new AbstractAction(){

            public void actionPerformed(ActionEvent ae) {
                ProfilesController.this.refreshProfile();
            }
        });
        this.renameProfile = repo.addAction("renameProfile", "Rename profile", "Rename current profile", "Profile", "d/a3", "z2", (Icon)SharedResources.getIcon((String)"rename.gif"), (Action)new AbstractAction(){

            public void actionPerformed(ActionEvent ae) {
                ProfilesController.this.renameProfile();
            }
        });
        this.removeProfile = repo.addAction("removeProfile", "Remove profile", "Remove current profile", "Profile", "d/a4", "z3", (Icon)SharedResources.getIcon((String)"borderRemove.gif"), (Action)new AbstractAction(){

            public void actionPerformed(ActionEvent ae) {
                ProfilesController.this.removeProfile();
            }
        });
        this.checkActionStates();
    }

    void checkActionStates() {
        boolean oneProfileSelected = this.mainModel.getStoredSettings().getSelectedItem() != null;
        this.restoreProfile.setEnabled(oneProfileSelected);
        this.renameProfile.setEnabled(oneProfileSelected);
        this.removeProfile.setEnabled(oneProfileSelected);
    }

    private String getCurrentProfileName() {
        SubSettingsList subs = this.mainModel.getStoredSettings();
        SubSettingsProxy current = (SubSettingsProxy)subs.getSelectedItem();
        return current == null ? null : current.getName();
    }

    void storeCurrentProfile() {
        String name = null;
        try {
            EditorOptionsDialog dial = new EditorOptionsDialog((Component)this.mainPanel);
            dial.setTitle("Store Profile");
            StoreProfileParams params = new StoreProfileParams(this.getCurrentProfileName());
            Object result = dial.showAndEditObject((Object)params);
            if ("OK".equals(result)) {
                name = params.getProfileName();
            }
            if (Comparison.isDefined(name)) {
                log.info((Object)("Store current profile with name='" + name + "'"));
                this.mainPanel.updateModel();
                this.mainModel.storeCurrentProfile(name);
                this.checkActionStates();
            } else {
                log.info((Object)"Store action cancelled by user");
            }
        }
        catch (Exception e) {
            log.error((Object)("Cannot store profile: " + name), (Throwable)e);
            ExceptionDialog.showExceptionDialog((Component)this.mainPanel, (String)"Profile error", (String)"Unable to add profile", (Throwable)e);
        }
    }

    void refreshProfile() {
        String currentProfileName = this.getCurrentProfileName();
        try {
            if (currentProfileName != null) {
                this.mainModel.useProfile(currentProfileName);
            }
        }
        catch (Exception e) {
            log.error((Object)("Cannot add refresh pipeline with profile " + currentProfileName), (Throwable)e);
            ExceptionDialog.showExceptionDialog((Component)this.mainPanel, (String)"Profile error", (String)("Unable to use current profile: " + currentProfileName), (Throwable)e);
        }
    }

    void renameProfile() {
        String oldName = this.getCurrentProfileName();
        String newName = null;
        try {
            newName = JOptionPane.showInputDialog(this.mainPanel, (Object)"New name for current profile");
            if (newName != null) {
                this.mainModel.changeProfileName(oldName, newName);
            } else {
                log.info((Object)"Rename action cancelled by user");
            }
        }
        catch (Exception e) {
            log.error((Object)("The current profile (" + oldName + ") cannot be renamed to: " + newName), (Throwable)e);
            ExceptionDialog.showExceptionDialog((Component)this.mainPanel, (String)"Profile error", (String)("Unable to rename profile: " + oldName + " --> " + newName), (Throwable)e);
        }
    }

    void removeProfile() {
        String profileName = this.getCurrentProfileName();
        try {
            this.mainModel.removeProfile(profileName);
            this.checkActionStates();
        }
        catch (Exception e) {
            log.error((Object)("The current profile (" + profileName + ") cannot be removed"), (Throwable)e);
            ExceptionDialog.showExceptionDialog((Component)this.mainPanel, (String)"Profile error", (String)("Unable to remove profile: " + profileName), (Throwable)e);
        }
    }

    public ToolModel getToolModel() {
        return this.mainModel;
    }

    public void beforeMnemonicAssignment(ActionRepository repo) {
    }

    public void menubarCreated(ActionRepository repo, JMenuBar menubar) {
    }

    public void toolbarCreated(ActionRepository repo, JToolBar toolbar) {
        int insertIndex = toolbar.getComponentCount() - 4;
        toolbar.setBorder((Border)new PartialLineBorder(new Color(153, 153, 153), 2, 2));
        toolbar.add((Component)new JLabel("Current Profile:"), insertIndex);
        toolbar.add(Box.createHorizontalStrut(4), insertIndex + 1);
        this.pipelineCombo = new JComboBox(this.mainModel.getStoredSettings());
        this.pipelineCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    ProfilesController.this.checkActionStates();
                    ProfilesController.this.refreshProfile();
                }
            }
        });
        toolbar.add((Component)this.pipelineCombo, insertIndex + 2);
        toolbar.add(Box.createHorizontalGlue());
    }

    @EditorConfig(label="")
    public class StoreProfileParams {
        private StoreAction action;
        private String existingProfileName;
        private String newProfileName;

        public StoreProfileParams(String currentProfileName) {
            if (currentProfileName != null) {
                this.action = StoreAction.OVERRIDE;
                this.existingProfileName = currentProfileName;
            } else {
                this.action = StoreAction.ADD_NEW;
            }
        }

        public ToolModel getToolModel() {
            return ProfilesController.this.getToolModel();
        }

        public String getProfileName() {
            return this.action == StoreAction.OVERRIDE ? this.existingProfileName : this.newProfileName;
        }

        @EditorConfig(label="Action", index=0, editor="net.sf.filePiper.gui.ProfileNameVisibilityEditor")
        public StoreAction getAction() {
            return this.action;
        }

        public void setAction(StoreAction act) {
            this.action = act;
        }

        @EditorConfig(label="Profile Name", editor="net.sf.filePiper.gui.ProfilesComboEditor")
        public String getExistingProfileName() {
            ProfilesComboEditor.class.getName();
            return this.existingProfileName;
        }

        public void setExistingProfileName(String profileName) {
            this.existingProfileName = profileName;
        }

        @EditorConfig(label="New Profile Name")
        public String getNewProfileName() {
            return this.newProfileName;
        }

        public void setNewProfileName(String profileName) {
            this.newProfileName = profileName;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum StoreAction {
        OVERRIDE("Override existing profile"),
        ADD_NEW("Add new profile");

        private String text;

        private StoreAction(String txt) {
            this.text = txt;
        }

        public String toString() {
            return this.text;
        }
    }
}

