/*
 * Decompiled with CFR 0.152.
 */
package net.sf.filePiper.gui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import net.sf.filePiper.gui.PiperMainPanel;
import net.sf.filePiper.gui.StatusBar;
import net.sf.filePiper.model.BasicPipeLineEnvironment;
import net.sf.filePiper.model.FileProcessor;
import net.sf.filePiper.model.Pipeline;
import net.sf.filePiper.model.PipelineEnvironment;
import net.sf.sfac.gui.ExceptionDialog;
import net.sf.sfac.gui.cmp.ConsoleDialog;
import org.apache.log4j.Logger;

public class GuiPipelineEnvironment
implements PipelineEnvironment {
    private static final Logger log = Logger.getLogger(GuiPipelineEnvironment.class);
    private Pipeline pipeline;
    private BasicPipeLineEnvironment asynchEnvironment;
    private PiperMainPanel mainPane;
    private Timer guiUpdateTimer;
    private Map<FileProcessor, StatusBar> processBars;
    private Boolean inconditionalOverwrite = null;
    private ConsoleDialog console;

    public GuiPipelineEnvironment(Pipeline processPipeline, PiperMainPanel mainPanel) {
        this.pipeline = processPipeline;
        this.mainPane = mainPanel;
        this.processBars = new HashMap<FileProcessor, StatusBar>();
        List<FileProcessor> processors = this.pipeline.getProcessors();
        List<StatusBar> procBars = this.mainPane.getProcessorStatus();
        int len = procBars.size();
        for (int i = 0; i < len; ++i) {
            this.processBars.put(processors.get(i), procBars.get(i));
        }
        this.asynchEnvironment = new BasicPipeLineEnvironment(processPipeline);
    }

    public void startUpdate() {
        if (this.guiUpdateTimer != null) {
            this.stopUpdate();
        }
        this.guiUpdateTimer = new Timer(333, new ActionListener(){

            public void actionPerformed(ActionEvent newE) {
                GuiPipelineEnvironment.this.updateGui();
            }
        });
        this.guiUpdateTimer.start();
    }

    public void stopUpdate() {
        if (this.guiUpdateTimer != null) {
            this.guiUpdateTimer.stop();
            this.guiUpdateTimer = null;
            if (this.asynchEnvironment.isErrored()) {
                Exception ex = this.asynchEnvironment.getException();
                ExceptionDialog.showExceptionDialog((Component)this.mainPane, (String)"Processing error", (String)("Processing aborted by exception\n" + ex), (Throwable)ex);
            }
        }
        this.updateGui();
        this.mainPane.finished();
    }

    void updateGui() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("--- GUI Update --- running=" + this.isRunning() + ", aborted=" + this.isAborted()));
        }
        this.mainPane.getSourceStatus().setStatus(this.getSourceBarText());
        for (FileProcessor processor : this.pipeline.getProcessors()) {
            StatusBar bar = this.processBars.get(processor);
            bar.setStatus(processor.getStatusMessage());
        }
        this.mainPane.getDestinationStatus().setStatus(this.getDestinationBarText());
    }

    private String getSourceBarText() {
        return this.getText("Processing", "processed", this.asynchEnvironment.getCurrentScannedDirectory(), this.asynchEnvironment.getCurrentInputFile(), this.asynchEnvironment.getInputFileCount(), 0, false);
    }

    private String getDestinationBarText() {
        return this.getText("Writing", "written", null, this.asynchEnvironment.getCurrentOutputFile(), this.asynchEnvironment.getOutputFileCount(), this.asynchEnvironment.getSkippedFileCount(), this.asynchEnvironment.isOutputToConsole());
    }

    private String getText(String actionNameOngoing, String actionNameDone, File scanning, File fil, int fileCount, int skippedCount, boolean toConsole) {
        boolean running = this.asynchEnvironment.isRunning();
        StringBuffer sb = new StringBuffer();
        if (running) {
            if (fileCount == 0) {
                if (skippedCount == 0) {
                    if (scanning != null) {
                        sb.append("Scanning dir: ");
                        sb.append(scanning.getAbsolutePath());
                    } else {
                        sb.append("Starting ...");
                    }
                } else {
                    sb.append(skippedCount);
                    sb.append(" skipped");
                }
            } else if (scanning != null) {
                sb.append("Scanning dir: ");
                sb.append(scanning.getAbsolutePath());
            } else {
                sb.append(actionNameOngoing);
                sb.append(" file ");
                if (fileCount > 1) {
                    sb.append("[");
                    sb.append(fileCount);
                    sb.append("] ");
                }
                if (toConsole) {
                    sb.append(" to console");
                } else {
                    sb.append(fil);
                }
                if (skippedCount > 0) {
                    sb.append(" (");
                    sb.append(skippedCount);
                    sb.append(" skipped)");
                }
            }
        } else if (this.asynchEnvironment.isAborted()) {
            sb.append("File processing aborted !");
        } else if (this.asynchEnvironment.isErrored()) {
            sb.append("File processing stopped by exception: " + this.asynchEnvironment.getException());
        } else {
            if (fileCount == 0) {
                sb.append("No file ");
            } else if (fileCount == 1) {
                sb.append("File ");
                if (!toConsole) {
                    sb.append(fil);
                    sb.append(" ");
                }
            } else {
                sb.append(fileCount);
                sb.append(" files ");
            }
            sb.append(actionNameDone);
            if (toConsole) {
                sb.append(" to console");
            }
            sb.append(".");
            if (skippedCount > 0) {
                sb.append(" (");
                sb.append(skippedCount);
                sb.append(" skipped)");
            }
        }
        return sb.toString();
    }

    private void asynchStopUpdates() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                GuiPipelineEnvironment.this.stopUpdate();
            }
        });
    }

    public void startProcessing() {
        this.inconditionalOverwrite = null;
        this.asynchEnvironment.startProcessing();
    }

    public void abortProcessing() {
        this.asynchEnvironment.abortProcessing();
    }

    public void finished(Exception e) {
        this.asynchEnvironment.finished(e);
        this.asynchStopUpdates();
    }

    public File getCurrentInputFile() {
        return this.asynchEnvironment.getCurrentInputFile();
    }

    public File getCurrentOutputFile() {
        return this.asynchEnvironment.getCurrentOutputFile();
    }

    public void outputtingToFile(File dest) {
        this.asynchEnvironment.outputtingToFile(dest);
    }

    public void scanningDirectory(File dir) {
        this.asynchEnvironment.scanningDirectory(dir);
    }

    public void processInputFile(File src) {
        this.asynchEnvironment.processInputFile(src);
    }

    public boolean shouldContinue() {
        return this.asynchEnvironment.shouldContinue();
    }

    public boolean canOverwriteFile(File existingFile) {
        if (this.inconditionalOverwrite != null) {
            return this.inconditionalOverwrite;
        }
        int res = JOptionPane.showOptionDialog(this.mainPane, "File " + existingFile.getAbsolutePath() + "\naleady exists\nOverwrite ?", "File exists", 1, 2, null, new String[]{"Yes", "Yes to all", "No", "No to all", "Abort"}, "Yes");
        switch (res) {
            case 0: {
                return true;
            }
            case 1: {
                this.inconditionalOverwrite = Boolean.TRUE;
                return true;
            }
            case 2: {
                return false;
            }
            case 3: {
                this.inconditionalOverwrite = Boolean.FALSE;
                return false;
            }
        }
        this.abortProcessing();
        this.inconditionalOverwrite = Boolean.FALSE;
        return false;
    }

    public void fileSkipped(File dest) {
        this.asynchEnvironment.fileSkipped(dest);
    }

    void getConsoleFromMainPanel() {
        assert (SwingUtilities.isEventDispatchThread());
        this.console = this.mainPane.getConsole();
        this.mainPane.setConsoleVisible(true);
    }

    public OutputStream getConsoleStream() {
        if (this.console == null) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        GuiPipelineEnvironment.this.getConsoleFromMainPanel();
                    }
                });
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to show console", e);
            }
        }
        return this.console.getConsoleStream();
    }

    public boolean isRunning() {
        return this.asynchEnvironment.isRunning();
    }

    public boolean isAborted() {
        return this.asynchEnvironment.isAborted();
    }

    public boolean isErrored() {
        return this.asynchEnvironment.isErrored();
    }
}

