package net.sf.filePiper.processors;


import java.io.IOException;
import java.io.InputStream;

import org.apache.log4j.Logger;
import net.sf.sfac.gui.editor.ObjectEditor;
import net.sf.sfac.gui.editor.cmp.ReadOnlyObjectEditor;
import net.sf.filePiper.model.ExecutionPhase;
import net.sf.filePiper.model.FileProcessor;
import net.sf.filePiper.model.FileProcessorEnvironment;
import net.sf.filePiper.model.InputFileInfo;
import net.sf.filePiper.model.StatusHolder;
import net.sf.sfac.setting.Settings;


/**
 * Processor doing nothing with the input file and creating no ouput.
 * 
 * @author BEROL
 */
public class NoOutputProcessor implements FileProcessor {


    Logger log = Logger.getLogger(NoOutputProcessor.class);
    private StatusHolder holder = new StatusHolder() {


        @Override
        protected String getRunningMessage() {
            StringBuilder sb = new StringBuilder();
            sb.append("Recieving ");
            appendCount(getInputFileCount(), "file", sb);
            sb.append("...");
            return sb.toString();
        }


        @Override
        protected String getDoneMessage() {
            StringBuilder sb = new StringBuilder();
            appendCount(getInputFileCount(), "file", sb);
            sb.append(" recieved.");
            return sb.toString();
        }
    };


    public String getProcessorName() {
        return "No Output";
    }


    public void init(Settings sett) {
    }


    public int getInputCardinality() {
        return ONE;
    }


    public int getOutputCardinality(int inputCardinality) {
        return NONE;
    }


    public void process(InputStream is, InputFileInfo line, FileProcessorEnvironment env) throws IOException {
        holder.inputFileStarted();
    }


    public void startBatch(FileProcessorEnvironment env) {
        holder.reset(ExecutionPhase.STARTING);
    }


    public void endBatch(FileProcessorEnvironment env) {
        holder.setCurrentPhase(env.getCurrentPhase());
    }


    public String getStatusMessage() {
        return holder.getStatusMessage();
    }


    public ObjectEditor getEditor() {
        return new ReadOnlyObjectEditor("Nothing is forwarded to output");
    }


}
