package net.sf.filePiper.model;


import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;


/**
 * Interface used to manage the pipe-line processing. 
 * 
 * @author BEROL
 */
public interface PipeComponent {

    
    public void processInputStream(InputStream input, InputFileInfo info);

    
    public OutputStream createOutputStream(InputFileInfo info) throws IOException;

    
    /**
     * Notififaction that the preceding processes (in the processing pipe) have finished the whole batch.
     */
    public void finished() throws IOException;


}
