package net.sf.filePiper.model;


import java.io.IOException;
import java.io.OutputStream;


/**
 * Interface used by the FileProcessor to interact with its environment.
 * 
 * @author BEROL
 */
public interface FileProcessorEnvironment {


    /**
     * Get an output stream for writing. <br>
     * The output stream will be created based on the information passed in the info (the proposed name) and the global pipeline
     * output settings.
     * 
     * @param info
     *            info about the file to create. The proposed name contained in this info can be used to create the final file
     *            name if the pipeline is configured to use it.
     * @return a suitable output stream.
     * @throws IOException
     */
    public OutputStream getOutputStream(InputFileInfo info) throws IOException;


    /**
     * Returns true if the file processing shoud continue, false if it was aborted. <br>
     * This flag should be checked on a regular basis by the file processor to react when processing is aborted.
     * 
     * @return true if the file processing shoud continue, false if it was aborted.
     */
    public boolean shouldContinue();


    /**
     * Get the object representing the whole file processing pipeline. <br>
     * In general, a FileProcessor does not need to access the Pipeline directly.
     * 
     * @return the object representing the whole file processing pipeline.
     */
    public Pipeline getPipeline();


    /**
     * Get the current execution phase of the processor environment.
     * 
     * @return the current execution phase of the processor environment.
     */
    public ExecutionPhase getCurrentPhase();


}
