package net.sf.filePiper.gui.borders;


import java.awt.Insets;

import javax.swing.Icon;
import javax.swing.JButton;


/**
 * A button with border appearing as rollover effect.
 */
public class RolloverButton extends JButton {


    public RolloverButton(Icon buttonIcon) {
        setIcon(buttonIcon);
        setMargin(new Insets(0, 0, 0, 0));
        setRolloverEnabled(true);
    }


    public boolean isBorderPainted() {
        return isEnabled() && getModel().isRollover();
    }

}
