package net.sf.filePiper.gui;


import java.util.ArrayList;
import java.util.List;

import net.sf.filePiper.gui.ProfilesController.StoreProfileParams;
import net.sf.filePiper.model.ToolModel;
import net.sf.sfac.gui.editor.cmp.ComboBoxEditor;
import net.sf.sfac.gui.utils.VariableComboBoxModel;
import net.sf.sfac.setting.SubSettingsList;
import net.sf.sfac.setting.SubSettingsProxy;


/**
 * Editor used to set the visibility of other editors in the dialog shown to store a profile (called from ProfilesController).
 * 
 * @author BEROL
 */
public class ProfilesComboEditor extends ComboBoxEditor {


    private VariableComboBoxModel model;


    public ProfilesComboEditor() {
        super(new VariableComboBoxModel(new Object[] {null}));
        model = (VariableComboBoxModel)getComboBoxModel();
    }


    @Override
    public void edit(Object objToEdit) {
        setupAvailableValues((StoreProfileParams) objToEdit);
        super.edit(objToEdit);
    }


    private void setupAvailableValues(StoreProfileParams params) {
        List<String> profileNames=new ArrayList<String>();
        ToolModel mainModel=params.getToolModel();
        
        SubSettingsList subs = mainModel.getStoredSettings();
        int nbrProfiles=subs.getSize();
        for (int i=0; i<nbrProfiles ; i++) {
            SubSettingsProxy proxy=(SubSettingsProxy)subs.getSubSettingAt(i);
            profileNames.add(proxy.getName());
        }
        model.setAvailableValues(profileNames.toArray());
    }


}
