/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fastupload.springmvc;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import net.sourceforge.fastupload.MultiPart;
import org.springframework.web.multipart.MultipartFile;

public class MultipartFileWrapper
implements MultipartFile,
Serializable {
    private static final long serialVersionUID = -3892688865117700968L;
    private MultiPart multiPart;

    public MultipartFileWrapper(MultiPart multiPart) {
        this.multiPart = multiPart;
    }

    public String getName() {
        return this.multiPart.getFieldName();
    }

    public String getOriginalFilename() {
        return this.multiPart.getFileName();
    }

    public String getContentType() {
        return this.multiPart.getContentType();
    }

    public boolean isEmpty() {
        return this.multiPart.getBytes() == 0;
    }

    public long getSize() {
        return this.multiPart.getBytes();
    }

    public byte[] getBytes() throws IOException {
        return this.multiPart.getContentBuffer();
    }

    public InputStream getInputStream() throws IOException {
        return this.multiPart.getInputStream();
    }

    public void transferTo(File dest) throws IOException, IllegalStateException {
        this.multiPart.toFile(dest.getAbsolutePath());
    }
}

