/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fastupload.springmvc;

import java.io.File;
import java.io.IOException;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import net.sourceforge.fastupload.FastUploadParser;
import net.sourceforge.fastupload.MultiPart;
import net.sourceforge.fastupload.ProgressListener;
import net.sourceforge.fastupload.springmvc.FastUploadSupport;
import org.springframework.web.context.ServletContextAware;
import org.springframework.web.multipart.MultipartException;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.MultipartResolver;
import org.springframework.web.multipart.support.DefaultMultipartHttpServletRequest;
import org.springframework.web.util.WebUtils;

public class FastuploadResolver
extends FastUploadSupport
implements MultipartResolver,
ServletContextAware {
    public void cleanupMultipart(MultipartHttpServletRequest request) {
        String repository = this.fileFactory.getRepository();
        if (repository != null && repository.trim().length() != 0) {
            for (MultiPart e : this.multiParts) {
                if (!e.isFile()) continue;
                this.doCleanup(e);
            }
        }
    }

    private void doCleanup(MultiPart e) {
        boolean deleted;
        File file = new File(e.getName());
        boolean bl = deleted = file.exists() && file.delete();
        if (!deleted && this.logger.isWarnEnabled()) {
            this.logger.warn((Object)("temporary file [" + e.getName() + "] delete failure"));
        }
    }

    public boolean isMultipart(HttpServletRequest request) {
        return "post".equalsIgnoreCase(request.getMethod()) && FastUploadParser.isMultiPart((HttpServletRequest)request);
    }

    public MultipartHttpServletRequest resolveMultipart(HttpServletRequest request) throws MultipartException {
        this.initFileFactory();
        try {
            this.fastUploadParser = new FastUploadParser(request, this.fileFactory);
            this.progressListener = new ProgressListener(this.fastUploadParser);
            this.multiParts = this.fastUploadParser.parseList();
            return new DefaultMultipartHttpServletRequest(request, this.getMultiPartFiles(), this.getParameters(), this.getParamContentTypes());
        }
        catch (IOException e) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error((Object)e);
                throw new MultipartException("resolve multipart/form-data ServletRequest error", (Throwable)e);
            }
            return null;
        }
    }

    public void setServletContext(ServletContext servletContext) {
        if (this.useTempRepository && this.tempRepository == null) {
            this.fileFactory.setRepository(WebUtils.getTempDir((ServletContext)servletContext).getAbsolutePath());
        }
    }
}

