/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fastupload.springmvc;

import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.fastupload.FastUploadParser;
import net.sourceforge.fastupload.FileFactory;
import net.sourceforge.fastupload.MultiPart;
import net.sourceforge.fastupload.ProgressListener;
import net.sourceforge.fastupload.springmvc.MultipartFileWrapper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

public abstract class FastUploadSupport {
    private static final int DEFAUT_THRESHOLD = 2000000;
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected FileFactory fileFactory = FileFactory.getInstance();
    protected FastUploadParser fastUploadParser;
    protected List<MultiPart> multiParts;
    protected boolean useTempRepository = false;
    protected String tempRepository;
    private String encoding;
    private int threshold = 2000000;
    private long maxContentLength = 2000000L;
    private String allowedTypes;
    private String allowedExtensions;
    protected ProgressListener progressListener;

    protected MultiValueMap<String, MultipartFile> getMultiPartFiles() {
        LinkedMultiValueMap multiValueMap = new LinkedMultiValueMap();
        for (MultiPart e : this.multiParts) {
            if (!e.isFile()) continue;
            multiValueMap.add((Object)e.getFieldName(), (Object)new MultipartFileWrapper(e));
        }
        return multiValueMap;
    }

    protected Map<String, String[]> getParameters() {
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        for (MultiPart e : this.multiParts) {
            if (e.isFile()) continue;
            try {
                String[] values = (String[])map.get(e.getFieldName());
                if (values == null) {
                    map.put(e.getFieldName(), new String[]{e.getString()});
                    continue;
                }
                String[] newParam = StringUtils.addStringToArray((String[])values, (String)e.getString());
                map.put(e.getFieldName(), newParam);
            }
            catch (UnsupportedEncodingException e1) {
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug((Object)e1);
            }
        }
        return map;
    }

    protected Map<String, String> getParamContentTypes() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (MultiPart e : this.multiParts) {
            map.put(e.getFieldName(), e.getContentType());
        }
        return map;
    }

    protected void initFileFactory() {
        this.fileFactory.setCharset(this.encoding == null ? "ISO-8859-1" : this.encoding);
        this.fileFactory.setThreshold(this.threshold);
        this.fileFactory.setMaxContentLength(this.maxContentLength);
        if (this.useTempRepository) {
            this.fileFactory.setRepository(this.tempRepository);
        }
        this.fileFactory.setAllowedExtensions(this.allowedExtensions);
        this.fileFactory.setAllowedTypes(this.allowedTypes);
    }

    public ProgressListener getProgressListener() {
        return this.progressListener;
    }

    public int getThreshold() {
        return this.threshold;
    }

    public void setThreshold(int threshold) {
        this.threshold = threshold;
    }

    public long getMaxContentLength() {
        return this.maxContentLength;
    }

    public void setMaxContentLength(long maxContentLength) {
        this.maxContentLength = maxContentLength;
    }

    public String getAllowedTypes() {
        return this.allowedTypes;
    }

    public void setAllowedTypes(String allowedTypes) {
        this.allowedTypes = allowedTypes;
    }

    public String getAllowedExtensions() {
        return this.allowedExtensions;
    }

    public void setAllowedExtensions(String allowedExtensions) {
        this.allowedExtensions = allowedExtensions;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public boolean isUseTempRepository() {
        return this.useTempRepository;
    }

    public void setUseTempRepository(boolean useTempRepository) {
        this.useTempRepository = useTempRepository;
    }

    public String getTempRepository() {
        return this.tempRepository;
    }

    public void setTempRepository(String tempRepository) {
        this.tempRepository = tempRepository;
    }
}

