/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package net.sourceforge.fastupload.springmvc;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;

import net.sourceforge.fastupload.MultiPart;

import org.springframework.web.multipart.MultipartFile;

/**
 * implement {@link org.springframework.web.multipart.MultipartFile} with
 * {@link net.sourceforge.fastupload.MultiPart}
 * 
 * @author <a href="mailto:link.qian@yahoo.com">Link Qian</a>
 * @author <a href="lkclkc88@sina.com">lkclkc88@sina.com</a>
 * 
 */
public class MultipartFileWrapper implements MultipartFile, Serializable {

    /**
     * generated random UID
     */
    private static final long serialVersionUID = -3892688865117700968L;

    private MultiPart multiPart;

    public MultipartFileWrapper(MultiPart multiPart) {
	super();
	this.multiPart = multiPart;
    }

    @Override
    public String getName() {
	return multiPart.getFieldName();
    }

    @Override
    public String getOriginalFilename() {
	return multiPart.getFileName();
    }

    @Override
    public String getContentType() {
	return multiPart.getContentType();
    }

    @Override
    public boolean isEmpty() {
	return multiPart.getBytes() == 0;
    }

    @Override
    public long getSize() {
	return multiPart.getBytes();
    }

    @Override
    public byte[] getBytes() throws IOException {
	return multiPart.getContentBuffer();
    }

    @Override
    public InputStream getInputStream() throws IOException {
	return multiPart.getInputStream();
    }

    @Override
    public void transferTo(File dest) throws IOException, IllegalStateException {
	multiPart.toFile(dest.getAbsolutePath());
    }

}
