/*
 * Decompiled with CFR 0.152.
 */
package org.esfinge.guardian.utils;

import java.lang.annotation.Annotation;
import org.esfinge.guardian.exception.AnnotationInstantiationException;

public class AnnotationUtils {
    private AnnotationUtils() {
    }

    public static Class<Annotation> getAnnotationType(String strAnnotation) {
        Class<Annotation> annotationType = null;
        try {
            annotationType = Class.forName(strAnnotation);
        }
        catch (Exception e) {
            throw new AnnotationInstantiationException(e);
        }
        return annotationType;
    }

    public static Class<? extends Annotation> getAnnotationType(Annotation annotation) {
        return annotation.getClass();
    }

    public static String getAnnotationFullname(Annotation annotation) {
        return AnnotationUtils.getAnnotationFullname(annotation.annotationType());
    }

    public static String getAnnotationFullname(Class<? extends Annotation> type) {
        String[] parts = type.toString().split(" ");
        return parts[1];
    }

    public static String extractAnnotationValue(Annotation annotation) {
        String annotationName = annotation.toString();
        String[] parts1 = annotationName.split("value=");
        if (parts1.length <= 1) {
            return null;
        }
        String strP1 = parts1[1];
        String[] parts2 = strP1.contains(",") ? strP1.split(",") : strP1.split("\\)");
        return parts2[0];
    }
}

