/*
 * Decompiled with CFR 0.152.
 */
package org.esfinge.guardian.interceptor.cglib;

import java.lang.reflect.Method;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import org.esfinge.guardian.context.WrappedObj;
import org.esfinge.guardian.exception.ProxyCreationException;
import org.esfinge.guardian.interceptor.GuardianInterceptor;

public class CGLIBProxy
extends GuardianInterceptor
implements MethodInterceptor {
    public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Exception {
        return this.guardianIntercept(obj, method, args);
    }

    @Override
    public <E> E createGuardedObject(E obj, Object[] constructorArgs, WrappedObj<?> ... dynamicContext) {
        CGLIBProxy proxy = new CGLIBProxy();
        proxy.setDynamicContext(dynamicContext);
        proxy.setGuardedObject(obj);
        Enhancer e = new Enhancer();
        e.setSuperclass(obj.getClass());
        e.setCallback((Callback)proxy);
        Object returnObj = null;
        try {
            if (constructorArgs == null) {
                returnObj = e.create();
            } else {
                Class[] argTypes = new Class[constructorArgs.length];
                int i = 0;
                while (i < constructorArgs.length) {
                    argTypes[i] = constructorArgs[i].getClass();
                    ++i;
                }
                returnObj = e.create(argTypes, constructorArgs);
            }
        }
        catch (Exception ex) {
            String msg = "Could not create proxy. Try checking the number of atributes in the constructor of: " + obj.getClass().getSimpleName();
            throw new ProxyCreationException(msg, ex);
        }
        return (E)returnObj;
    }
}

