/*
 * Decompiled with CFR 0.152.
 */
package org.esfinge.guardian.context;

import java.lang.reflect.Method;
import org.esfinge.guardian.context.WrappedObj;
import org.esfinge.guardian.context.entity.ContextMap;
import org.esfinge.guardian.context.entity.ContextType;
import org.esfinge.guardian.exception.ProxyCreationException;
import org.esfinge.guardian.init.Repository;
import org.esfinge.guardian.interceptor.GuardianInterceptor;
import org.esfinge.guardian.invoker.Invoker;
import org.esfinge.guardian.utils.ServiceLocator;

public class AuthorizationContext {
    private Object guardedObj;
    private Method guardedMethod;
    private Object[] guardedMethodArgs;
    private ContextMap subject;
    private ContextMap environment;
    private ContextMap resource;
    private Invoker invoker;
    private Repository repository;
    private WrappedObj<?>[] wrappedObjs;

    public AuthorizationContext() {
    }

    public AuthorizationContext(Object guardedObj, Method guardedMethod, Object[] guardedMethodArgs) {
        this.guardedObj = guardedObj;
        this.guardedMethod = guardedMethod;
        this.guardedMethodArgs = guardedMethodArgs;
        this.subject = new ContextMap();
        this.environment = new ContextMap();
        this.resource = new ContextMap();
        this.invoker = ServiceLocator.getServiceImplementation(Invoker.class);
        this.repository = Repository.getInstance();
    }

    public AuthorizationContext(Object guardedObj, Method guardedMethod, Object[] guardedMethodArgs, WrappedObj<?> ... wrappedObjs) {
        this(guardedObj, guardedMethod, guardedMethodArgs);
        this.wrappedObjs = wrappedObjs;
    }

    public static <E> E guardObject(E object, WrappedObj<?> ... wrappedObjs) {
        GuardianInterceptor interceptor = ServiceLocator.getServiceImplementation(GuardianInterceptor.class);
        return AuthorizationContext.guardObject(interceptor, object, null, wrappedObjs);
    }

    public static <E> E guardObject(E object, Object[] constructorArgs, WrappedObj<?> ... wrappedObjs) {
        GuardianInterceptor interceptor = ServiceLocator.getServiceImplementation(GuardianInterceptor.class);
        return AuthorizationContext.guardObject(interceptor, object, constructorArgs, wrappedObjs);
    }

    public static <E> E guardObject(GuardianInterceptor interceptor, E object, Object[] constructorArgs, WrappedObj<?> ... wrappedObjs) {
        E guardedObj = null;
        try {
            guardedObj = interceptor.createGuardedObject(object, constructorArgs, wrappedObjs);
        }
        catch (Exception e) {
            throw new ProxyCreationException("Could not create proxy", e);
        }
        return guardedObj;
    }

    public static <E> WrappedObj<E> wrapAsResourceProp(String contextName, E wrappedObj) {
        return new WrappedObj<E>(contextName, wrappedObj, ContextType.RESOURCE);
    }

    public static <E> WrappedObj<E> wrapAsSubjectProp(String contextName, E wrappedObj) {
        return new WrappedObj<E>(contextName, wrappedObj, ContextType.SUBJECT);
    }

    public static <E> WrappedObj<E> wrapAsEnvironmentProp(String contextName, E wrappedObj) {
        return new WrappedObj<E>(contextName, wrappedObj, ContextType.ENVIRONMENT);
    }

    public static void main(String[] args) {
    }

    public Invoker getInvoker() {
        return this.invoker;
    }

    public void setInvoker(Invoker invoker) {
        this.invoker = invoker;
    }

    public Repository getRepository() {
        return this.repository;
    }

    public void setRepository(Repository authorizationRepository) {
        this.repository = authorizationRepository;
    }

    public Object getGuardedObj() {
        return this.guardedObj;
    }

    public void setGuardedObj(Object guardedObj) {
        this.guardedObj = guardedObj;
    }

    public Method getGuardedMethod() {
        return this.guardedMethod;
    }

    public void setGuardedMethod(Method guardedMethod) {
        this.guardedMethod = guardedMethod;
    }

    public Object[] getGuardedMethodArgs() {
        return this.guardedMethodArgs;
    }

    public void setGuardedMethodArgs(Object[] guardedMethodArgs) {
        this.guardedMethodArgs = guardedMethodArgs;
    }

    public ContextMap getSubject() {
        return this.subject;
    }

    public void setSubject(ContextMap subject) {
        this.subject = subject;
    }

    public ContextMap getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(ContextMap environment) {
        this.environment = environment;
    }

    public ContextMap getResource() {
        return this.resource;
    }

    public void setResource(ContextMap resource) {
        this.resource = resource;
    }

    public WrappedObj<?>[] getWrappedObjs() {
        return this.wrappedObjs;
    }

    public void setWrappedObjs(WrappedObj<?>[] wrappedObjs) {
        this.wrappedObjs = wrappedObjs;
    }
}

