/*
 * Decompiled with CFR 0.152.
 */
package org.esfinge.guardian.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.esfinge.guardian.exception.ServiceLocatorMisuseException;

public class ServiceLocator {
    private static Map<Class, Object> classRelatedServices = new HashMap<Class, Object>();

    public static <E> E getServiceImplementation(Class<E> clazzType) {
        if (classRelatedServices.containsKey(clazzType)) {
            Object objE;
            try {
                objE = classRelatedServices.get(clazzType);
            }
            catch (Exception e) {
                throw new ServiceLocatorMisuseException("Wrong use of ServiceLocator.getServiceImplementation");
            }
            return (E)objE;
        }
        ServiceLoader<E> loader = ServiceLoader.load(clazzType);
        Iterator<E> it = loader.iterator();
        Object current = null;
        if (it.hasNext()) {
            try {
                current = it.next();
            }
            catch (Exception e) {
                throw new ServiceLocatorMisuseException("Wrong use of ServiceLocator.getServiceImplementation");
            }
            classRelatedServices.put(clazzType, current);
        }
        return (E)current;
    }

    public static <E> List<E> getServiceImplementationList(Class<E> clazzType) {
        if (classRelatedServices.containsKey(clazzType)) {
            List objE;
            try {
                objE = (List)classRelatedServices.get(clazzType);
            }
            catch (Exception e) {
                throw new ServiceLocatorMisuseException("Wrong use of ServiceLocator.getServiceImplementationList");
            }
            return objE;
        }
        ServiceLoader<E> loader = ServiceLoader.load(clazzType);
        Iterator<E> it = loader.iterator();
        ArrayList<E> list = new ArrayList<E>();
        while (it.hasNext()) {
            list.add(it.next());
        }
        classRelatedServices.put(clazzType, list);
        return list;
    }
}

