/*
 * Decompiled with CFR 0.152.
 */
package org.esfinge.guardian.utils;

import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.esfinge.guardian.authorizer.Authorizer;
import org.esfinge.guardian.context.AuthorizationContext;
import org.esfinge.guardian.init.AuthorizationAnnotations;
import org.esfinge.guardian.init.CachedAuthorizers;
import org.esfinge.guardian.init.Repository;

public class AuthorizerUtils {
    public static Set<Annotation> getAuthorizationAnnotations(AuthorizationContext context, Annotation[] annotations) {
        Repository repository = context.getRepository();
        if (Objects.isNull(repository.getAuthorizationAnnotations())) {
            HashSet<String> set = new HashSet<String>();
            Annotation[] annotationArray = annotations;
            int n = annotations.length;
            int n2 = 0;
            while (n2 < n) {
                Annotation ann = annotationArray[n2];
                set.add(ann.annotationType().getName());
                ++n2;
            }
            repository.setAuthorizationAnnotations(new AuthorizationAnnotations(set));
        }
        if (Objects.isNull(repository.getCachedAuthorizers())) {
            repository.setCachedAuthorizers(new CachedAuthorizers());
        }
        return repository.getAuthorizationAnnotations().extractAuthorizationAnnotations(annotations, new HashSet<Annotation>());
    }

    public static Authorizer<? extends Annotation> getAuthorizer(AuthorizationContext context, Annotation authorizationAnnotation) {
        return context.getRepository().getCachedAuthorizers().getAuthorizer(context, context.getGuardedMethod(), authorizationAnnotation);
    }
}

