/*
 * Decompiled with CFR 0.152.
 */
package org.esfinge.guardian.init;

import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Set;
import org.esfinge.guardian.utils.AnnotationUtils;

public class AuthorizationAnnotations {
    private Set<Class<? extends Annotation>> allAuthorizationAnnotations = new HashSet<Class<? extends Annotation>>();

    public AuthorizationAnnotations(Set<String> annotations) {
        this.cacheAuthorizationAnnotations(annotations);
    }

    private void cacheAuthorizationAnnotations(Set<String> authorizationAnnotations) {
        for (String annotation : authorizationAnnotations) {
            Class<Annotation> annotationType = AnnotationUtils.getAnnotationType(annotation);
            this.allAuthorizationAnnotations.add(annotationType);
        }
    }

    public void setAnnotationSet(Set<Class<? extends Annotation>> authorizationAnnotations) {
        this.allAuthorizationAnnotations = authorizationAnnotations;
    }

    public Boolean contains(Annotation annotation) {
        Class<? extends Annotation> type = annotation.annotationType();
        if (this.allAuthorizationAnnotations.contains(type)) {
            return true;
        }
        return false;
    }

    public Set<Annotation> extractAuthorizationAnnotations(Annotation[] annotations, Set<Annotation> authorizationAnnotations) {
        Annotation[] annotationArray = annotations;
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation annotation = annotationArray[n2];
            if (this.contains(annotation).booleanValue()) {
                authorizationAnnotations.add(annotation);
            }
            if (!annotation.annotationType().getPackage().getName().startsWith("java.lang.annotation")) {
                authorizationAnnotations.addAll(this.extractAuthorizationAnnotations(annotation.annotationType().getAnnotations(), authorizationAnnotations));
            }
            ++n2;
        }
        return authorizationAnnotations;
    }
}

