/*
 * Decompiled with CFR 0.152.
 */
package org.esfinge.guardian.authorizer;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Set;
import org.esfinge.guardian.authorizer.Authorizer;
import org.esfinge.guardian.context.AuthorizationContext;
import org.esfinge.guardian.exception.AuthorizationException;
import org.esfinge.guardian.populator.PopulatorProcessor;
import org.esfinge.guardian.utils.AuthorizerUtils;

public class AuthorizerProcessor {
    public static void process(AuthorizationContext context) {
        PopulatorProcessor.process(context);
        Method guardedMethod = context.getGuardedMethod();
        Set<Annotation> authorizationAnnotations = AuthorizerUtils.getAuthorizationAnnotations(context, guardedMethod.getAnnotations());
        boolean authorized = true;
        if (!authorizationAnnotations.isEmpty()) {
            for (Annotation annotation : authorizationAnnotations) {
                Authorizer<? extends Annotation> authorizer = AuthorizerUtils.getAuthorizer(context, annotation);
                boolean bl = authorized = authorized && authorizer.authorize(context, annotation) != false;
                if (!authorized) break;
            }
        }
        if (!authorized) {
            throw new AuthorizationException("Unauthorized Access");
        }
    }
}

