/*
 * Decompiled with CFR 0.152.
 */
package net.sf.esfinge.gamification.proxy;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.logging.Logger;
import net.sf.esfinge.gamification.exception.GamificationConfigurationException;
import net.sf.esfinge.gamification.proxy.GameInvoker;
import net.sf.esfinge.metadata.AnnotationValidationException;
import net.sf.esfinge.metadata.validate.MetadataValidator;
import org.esfinge.guardian.context.AuthorizationContext;
import org.esfinge.guardian.context.WrappedObj;
import org.esfinge.guardian.exception.ProxyCreationException;

public class GameProxy
implements InvocationHandler {
    private Object encapsulated;
    private Object guardedObject;

    private GameProxy(Object encapsulated) {
        this.encapsulated = encapsulated;
        try {
            this.guardedObject = AuthorizationContext.guardObject((Object)encapsulated, (WrappedObj[])new WrappedObj[0]);
        }
        catch (ProxyCreationException e) {
            Logger.getLogger(this.getClass().getName() + ": " + e.getMessage());
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            Object returnValue = method.invoke(this.guardedObject, args);
            GameInvoker gameInvoker = GameInvoker.getInstance();
            gameInvoker.registerAchievment(this.encapsulated, method, args);
            return returnValue;
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    }

    public static <T> T createProxy(T encapsulated) {
        Object obj = Proxy.newProxyInstance(encapsulated.getClass().getClassLoader(), encapsulated.getClass().getInterfaces(), (InvocationHandler)new GameProxy(encapsulated));
        try {
            MetadataValidator.validateMetadataOn(encapsulated.getClass());
            for (Class<?> interf : encapsulated.getClass().getInterfaces()) {
                MetadataValidator.validateMetadataOn(interf);
            }
        }
        catch (AnnotationValidationException e) {
            throw new GamificationConfigurationException("Invalid annotation configuration", e);
        }
        return (T)obj;
    }
}

