/*
 * Decompiled with CFR 0.152.
 */
package net.sf.esfinge.gamification.mechanics.database.nosql;

import com.mongodb.client.MongoCollection;
import net.sf.esfinge.gamification.achievement.Achievement;
import net.sf.esfinge.gamification.achievement.Point;
import net.sf.esfinge.gamification.achievement.Ranking;
import net.sf.esfinge.gamification.achievement.Reward;
import net.sf.esfinge.gamification.achievement.Trophy;
import net.sf.esfinge.gamification.mechanics.database.Storage;
import net.sf.esfinge.gamification.mechanics.database.nosql.MongoPointStorage;
import net.sf.esfinge.gamification.mechanics.database.nosql.MongoRankingStorage;
import net.sf.esfinge.gamification.mechanics.database.nosql.MongoRewardStorage;
import net.sf.esfinge.gamification.mechanics.database.nosql.MongoTrophyStorage;
import org.bson.Document;

public class MongoStorageFactory {
    private MongoCollection<Document> collection;

    public MongoStorageFactory(MongoCollection<Document> collection) {
        this.collection = collection;
    }

    public Storage storageFor(Achievement a) {
        if (a instanceof Point) {
            return new MongoPointStorage(this.collection);
        }
        if (a instanceof Ranking) {
            return new MongoRankingStorage(this.collection);
        }
        if (a instanceof Reward) {
            return new MongoRewardStorage(this.collection);
        }
        if (a instanceof Trophy) {
            return new MongoTrophyStorage(this.collection);
        }
        throw new RuntimeException("Cannot create Storage for " + a.getClass().getName());
    }
}

