/*
 * Decompiled with CFR 0.152.
 */
package net.sf.esfinge.gamification.mechanics.database.nosql;

import com.mongodb.BasicDBObject;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Projections;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.sf.esfinge.gamification.achievement.Achievement;
import net.sf.esfinge.gamification.achievement.Reward;
import net.sf.esfinge.gamification.mechanics.database.Storage;
import org.bson.Document;
import org.bson.conversions.Bson;

public class MongoRewardStorage
implements Storage {
    private MongoCollection<Document> collection;

    public MongoRewardStorage(MongoCollection<Document> c) {
        this.collection = c;
    }

    @Override
    public void insert(Object user, Achievement a) throws SQLException {
        Document document = this.toDocument(user, a);
        this.collection.insertOne((Object)document);
    }

    @Override
    public Reward select(Object user, String name) throws SQLException {
        BasicDBObject query = new BasicDBObject().append("user", user).append("achievement.name", (Object)name).append("achievement.type", (Object)"Reward");
        Optional<Object> achievement = Optional.ofNullable(this.collection.find((Bson)query).first());
        Reward r = null;
        if (achievement.isPresent()) {
            Document achievementProperties = (Document)((Document)achievement.get()).get((Object)"achievement", Document.class);
            r = new Reward(name, achievementProperties.getBoolean((Object)"isUsed"));
        }
        return r;
    }

    @Override
    public Map<String, Achievement> select(Object user) throws SQLException {
        HashMap<String, Achievement> achievements = new HashMap<String, Achievement>();
        FindIterable results = this.collection.find(Filters.and((Bson[])new Bson[]{Filters.eq((String)"user", (Object)user), Filters.eq((String)"achievement.type", (Object)"Reward")})).projection(Projections.fields((Bson[])new Bson[]{Projections.exclude((String[])new String[]{"achievement.type"}), Projections.excludeId()}));
        for (Document result : results) {
            Document achievement = (Document)result.get((Object)"achievement", Document.class);
            Reward r = new Reward(achievement.getString((Object)"name"), achievement.getBoolean((Object)"isUsed"));
            achievements.put(r.getName(), r);
        }
        return achievements;
    }

    @Override
    public void update(Object user, Achievement a) throws SQLException {
        BasicDBObject query = new BasicDBObject().append("user", user).append("achievement.name", (Object)a.getName()).append("achievement.type", (Object)"Reward");
        Document update = new Document("$set", (Object)new Document().append("achievement.isUsed", (Object)((Reward)a).isUsed()));
        this.collection.updateOne((Bson)query, (Bson)update);
    }

    @Override
    public void delete(Object user, Achievement p) throws SQLException {
        this.collection.deleteOne(Filters.and((Bson[])new Bson[]{Filters.eq((String)"user", (Object)user), Filters.eq((String)"achievement.name", (Object)p.getName()), Filters.eq((String)"achievement.type", (Object)"Reward")}));
    }

    @Override
    public Map<String, Achievement> selectAll() throws SQLException {
        HashMap<String, Achievement> achievements = new HashMap<String, Achievement>();
        FindIterable results = this.collection.find(Filters.eq((String)"achievement.type", (Object)"Reward"));
        for (Document result : results) {
            Document achievement = (Document)result.get((Object)"achievement", Document.class);
            Reward r = new Reward(achievement.getString((Object)"name"), achievement.getBoolean((Object)"isUsed"));
            achievements.put(r.getName(), r);
        }
        return achievements;
    }

    private Document toDocument(Object user, Achievement a) {
        Reward r = (Reward)a;
        return new Document().append("user", user).append("achievement", (Object)new BasicDBObject("type", (Object)"Reward").append("name", (Object)r.getName()).append("isUsed", (Object)r.isUsed()));
    }
}

