/*
 * Decompiled with CFR 0.152.
 */
package net.sf.esfinge.gamification.mechanics.database.sql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.SortOrder;
import net.sf.esfinge.gamification.achievement.Achievement;
import net.sf.esfinge.gamification.achievement.Point;
import net.sf.esfinge.gamification.mechanics.database.Storage;

public class PointStorage
implements Storage {
    private Connection connection;

    public PointStorage(Connection c) {
        this.connection = c;
    }

    @Override
    public void insert(Object user, Achievement a) throws SQLException {
        Point p = (Point)a;
        PreparedStatement stmt = this.connection.prepareStatement("insert into gamification.points (userid, name, points) values (?,?,?)");
        stmt.setString(1, user.toString());
        stmt.setString(2, p.getName());
        stmt.setInt(3, p.getQuantity());
        stmt.execute();
    }

    @Override
    public Achievement select(Object user, String name) throws SQLException {
        PreparedStatement stmt = this.connection.prepareStatement("select * from gamification.points where userid=? and name = ?");
        stmt.setString(1, user.toString());
        stmt.setString(2, name);
        ResultSet rs = stmt.executeQuery();
        if (rs.next()) {
            int q = rs.getInt("points");
            Point p2 = new Point(q, name);
            return p2;
        }
        return null;
    }

    @Override
    public Map<String, Achievement> select(Object user) throws SQLException {
        HashMap<String, Achievement> map = new HashMap<String, Achievement>();
        PreparedStatement stmt = this.connection.prepareStatement("select * from gamification.points where userid=?");
        stmt.setString(1, user.toString());
        ResultSet rs = stmt.executeQuery();
        while (rs.next()) {
            String name = rs.getString("name");
            int q = rs.getInt("points");
            Point p = new Point(q, name);
            map.put(p.getName(), p);
        }
        return map;
    }

    @Override
    public void update(Object user, Achievement a) throws SQLException {
        Point p = (Point)a;
        PreparedStatement stmt = this.connection.prepareStatement("update gamification.points set points = ? where userid=? and name=?");
        stmt.setString(2, user.toString());
        stmt.setString(3, p.getName());
        stmt.setInt(1, p.getQuantity());
        stmt.execute();
    }

    @Override
    public void delete(Object user, Achievement a) throws SQLException {
        Point p = (Point)a;
        PreparedStatement stmt = this.connection.prepareStatement("delete from gamification.points where userid=? and name=?");
        stmt.setString(1, user.toString());
        stmt.setString(2, p.getName());
        stmt.execute();
    }

    @Override
    public Map<String, Achievement> selectAll() throws SQLException {
        HashMap<String, Point> map = null;
        PreparedStatement stmt = this.connection.prepareStatement("select userid, name, points from gamification.points");
        ResultSet rs = stmt.executeQuery();
        if (rs != null) {
            map = new HashMap<String, Point>();
            while (rs.next()) {
                String name = rs.getString("name");
                int quantity = rs.getInt("points");
                Point point = new Point(quantity, name);
                map.put(rs.getString("userid"), point);
            }
        }
        return map;
    }

    public Map<String, Achievement> findAll(SortOrder sortOrder) {
        return null;
    }
}

