/*
 * Decompiled with CFR 0.152.
 */
package net.sf.esfinge.gamification.mechanics;

import java.util.HashMap;
import java.util.Map;
import net.sf.esfinge.gamification.achievement.Achievement;
import net.sf.esfinge.gamification.mechanics.Game;

public class GameMemoryStorage
extends Game {
    private Map<Object, Map<String, Achievement>> achievments = new HashMap<Object, Map<String, Achievement>>();

    @Override
    public void insertAchievement(Object user, Achievement a) {
        if (!this.achievments.containsKey(user)) {
            this.achievments.put(user, new HashMap());
        }
        Map<String, Achievement> userAchiev = this.achievments.get(user);
        userAchiev.put(a.getName(), a);
    }

    @Override
    public void deleteAchievement(Object user, Achievement a) {
        Map<String, Achievement> userAchiev;
        if (!this.achievments.containsKey(user)) {
            this.achievments.put(user, new HashMap());
        }
        if ((userAchiev = this.achievments.get(user)).containsKey(a.getName())) {
            userAchiev.remove(a.getName());
        }
    }

    @Override
    public Achievement getAchievement(Object user, String achievName) {
        if (!this.achievments.containsKey(user)) {
            this.achievments.put(user, new HashMap());
        }
        return this.achievments.get(user).get(achievName);
    }

    @Override
    public Map<String, Achievement> getAchievements(Object user) {
        return this.achievments.get(user);
    }

    @Override
    public void updateAchievement(Object user, Achievement a) {
        this.insertAchievement(user, a);
    }

    @Override
    public Map<String, Achievement> getAllAchievements(Class<? extends Achievement> type) {
        HashMap<String, Achievement> map = new HashMap<String, Achievement>();
        for (Map.Entry<Object, Map<String, Achievement>> keys : this.achievments.entrySet()) {
            String key = (String)keys.getKey();
            Map<String, Achievement> userAchievement = this.achievments.get(key);
            for (Achievement achievement : userAchievement.values()) {
                if (type.getTypeName() != achievement.getClass().getTypeName()) continue;
                map.put(key, achievement);
            }
        }
        return map;
    }
}

